/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.lifecycle;

import dk.cloudcreate.essentials.components.foundation.Lifecycle;
import dk.cloudcreate.essentials.components.foundation.lifecycle.LifecycleManager;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public final class DefaultLifecycleManager
implements LifecycleManager,
ApplicationListener<ApplicationContextEvent>,
ApplicationContextAware {
    public static final Logger log = LoggerFactory.getLogger(DefaultLifecycleManager.class);
    private ApplicationContext applicationContext;
    private boolean hasStartedLifeCycleBeans;
    private Map<String, Lifecycle> lifeCycleBeans;
    private final Consumer<ApplicationContext> contextRefreshedEventConsumer;
    private final boolean isStartLifecycles;

    public DefaultLifecycleManager(Consumer<ApplicationContext> contextRefreshedEventConsumer, boolean isStartLifecycles) {
        this.contextRefreshedEventConsumer = (Consumer)FailFast.requireNonNull(contextRefreshedEventConsumer);
        this.isStartLifecycles = isStartLifecycles;
        log.info("Initializing {} with isStartLifecycles = {}", (Object)this.getClass().getSimpleName(), (Object)isStartLifecycles);
    }

    public DefaultLifecycleManager(boolean isStartLifecycles) {
        this(event -> {}, isStartLifecycles);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            log.info(event.getClass().getSimpleName());
            this.startLifecycleBeans();
        } else if (event instanceof ContextClosedEvent) {
            log.info("{} - has started life cycle beans: {}", (Object)event.getClass().getSimpleName(), (Object)this.hasStartedLifeCycleBeans);
            this.onContextClosed();
        }
    }

    private void onContextClosed() {
        if (this.hasStartedLifeCycleBeans) {
            this.lifeCycleBeans.forEach((beanName, lifecycleBean) -> {
                if (lifecycleBean.isStarted()) {
                    log.info("Stopping {} bean '{}' of type '{}'", new Object[]{Lifecycle.class.getSimpleName(), beanName, lifecycleBean.getClass().getName()});
                    lifecycleBean.stop();
                }
            });
            this.hasStartedLifeCycleBeans = false;
        }
    }

    private void startLifecycleBeans() {
        if (!this.isStartLifecycles) {
            log.debug("Start of lifecycle beans is disabled");
            this.contextRefreshedEventConsumer.accept(this.applicationContext);
            return;
        }
        if (!this.hasStartedLifeCycleBeans) {
            this.contextRefreshedEventConsumer.accept(this.applicationContext);
            this.hasStartedLifeCycleBeans = true;
            this.lifeCycleBeans = this.applicationContext.getBeansOfType(Lifecycle.class);
            this.lifeCycleBeans.forEach((beanName, lifecycleBean) -> {
                if (!lifecycleBean.isStarted()) {
                    log.info("Starting {} bean '{}' of type '{}'", new Object[]{Lifecycle.class.getSimpleName(), beanName, lifecycleBean.getClass().getName()});
                    lifecycleBean.start();
                }
            });
        }
    }
}

