/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.operations;

import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessageHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.ConsumeFromQueue;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;

public final class ConsumeFromQueueBuilder {
    private String consumerName = UUID.randomUUID().toString();
    private QueueName queueName;
    private RedeliveryPolicy redeliveryPolicy;
    private int parallelConsumers;
    private Optional<ScheduledExecutorService> consumerExecutorService = Optional.empty();
    private Duration pollingInterval = Duration.ofMillis(100L);
    private QueuedMessageHandler queueMessageHandler;

    public ConsumeFromQueueBuilder setQueueName(QueueName queueName) {
        this.queueName = queueName;
        return this;
    }

    public ConsumeFromQueueBuilder setPollingInterval(Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    public ConsumeFromQueueBuilder setConsumerName(String consumerName) {
        this.consumerName = consumerName;
        return this;
    }

    public ConsumeFromQueueBuilder setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
        return this;
    }

    public ConsumeFromQueueBuilder setParallelConsumers(int parallelConsumers) {
        this.parallelConsumers = parallelConsumers;
        return this;
    }

    public ConsumeFromQueueBuilder setConsumerExecutorService(ScheduledExecutorService consumerExecutorService) {
        this.consumerExecutorService = Optional.of(consumerExecutorService);
        return this;
    }

    public ConsumeFromQueueBuilder setQueueMessageHandler(QueuedMessageHandler queueMessageHandler) {
        this.queueMessageHandler = queueMessageHandler;
        return this;
    }

    public ConsumeFromQueue build() {
        return new ConsumeFromQueue(this.consumerName, this.queueName, this.redeliveryPolicy, this.parallelConsumers, this.consumerExecutorService, this.queueMessageHandler, this.pollingInterval);
    }
}

