/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.operations;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessagesBuilder;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public final class QueueMessages {
    public final QueueName queueName;
    public List<? extends Message> messages;
    private Optional<Duration> deliveryDelay;

    public static QueueMessagesBuilder builder() {
        return new QueueMessagesBuilder();
    }

    public QueueMessages(QueueName queueName, List<? extends Message> messages, Optional<Duration> deliveryDelay) {
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.messages = (List)FailFast.requireNonNull(messages, (String)"No payloads provided");
        this.deliveryDelay = (Optional)FailFast.requireNonNull(deliveryDelay, (String)"No deliveryDelay provided");
    }

    public QueueMessages(QueueName queueName, List<? extends Message> messages, Duration deliveryDelay) {
        this(queueName, messages, Optional.ofNullable(deliveryDelay));
    }

    public QueueName getQueueName() {
        return this.queueName;
    }

    public List<? extends Message> getMessages() {
        return this.messages;
    }

    public Optional<Duration> getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public void setDeliveryDelay(Optional<Duration> deliveryDelay) {
        this.deliveryDelay = (Optional)FailFast.requireNonNull(deliveryDelay, (String)"No deliveryDelay provided");
    }

    public void setDeliveryDelay(Duration deliveryDelay) {
        this.deliveryDelay = Optional.ofNullable(deliveryDelay);
    }

    public void setMessages(List<Message> messages) {
        this.messages = (List)FailFast.requireNonNull(messages, (String)"No payloads provided");
    }

    public String toString() {
        return "QueueMessages{queueName=" + this.queueName + ", messages=" + this.messages + "}";
    }

    public void validate() {
        FailFast.requireNonNull((Object)((Object)this.queueName), (String)"You must provide a queueName");
        FailFast.requireNonNull(this.messages, (String)"You must provide a messages list");
        FailFast.requireNonNull(this.deliveryDelay, (String)"You must provide a deliveryDelay option");
    }
}

