/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.postgresql;

import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.sql.SQLException;
import java.time.Duration;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlExecutionTimeLogger
implements SqlLogger {
    private final Logger log = LoggerFactory.getLogger((String)"EventStore.Sql");

    public void logBeforeExecution(StatementContext context) {
    }

    public void logAfterExecution(StatementContext context) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Execution time: {} ms - {}", (Object)Duration.between(context.getExecutionMoment(), context.getCompletionMoment()).toMillis(), (Object)context.getRenderedSql());
        }
    }

    public void logException(StatementContext context, SQLException ex) {
        this.log.error(MessageFormatter.msg((String)"Failed Execution time: {} ms - {}", (Object[])new Object[]{Duration.between(context.getExecutionMoment(), context.getExceptionMoment()).toMillis(), context.getRenderedSql()}), (Throwable)ex);
    }
}

