/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.kotlin.eventsourcing.adapters;

import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.ConfigurableEventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.EventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateType;
import dk.cloudcreate.essentials.components.kotlin.eventsourcing.AggregateTypeConfiguration;
import dk.cloudcreate.essentials.components.kotlin.eventsourcing.Decider;
import dk.cloudcreate.essentials.components.kotlin.eventsourcing.adapters.DeciderCommandHandlerAdapter;
import dk.cloudcreate.essentials.reactive.command.CommandBus;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/adapters/DeciderAndAggregateTypeConfigurator;", "", "eventStore", "Ldk/cloudcreate/essentials/components/eventsourced/eventstore/postgresql/ConfigurableEventStore;", "commandBus", "Ldk/cloudcreate/essentials/reactive/command/CommandBus;", "aggregateTypeConfigurations", "", "Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/AggregateTypeConfiguration;", "deciders", "Ldk/cloudcreate/essentials/components/kotlin/eventsourcing/Decider;", "(Ldk/cloudcreate/essentials/components/eventsourced/eventstore/postgresql/ConfigurableEventStore;Ldk/cloudcreate/essentials/reactive/command/CommandBus;Ljava/util/List;Ljava/util/List;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addAggregateTypeConfigurationsToTheEventStore", "", "registerDecidersAsCommandHandlersOnTheCommandBus", "kotlin-eventsourcing"})
@SourceDebugExtension(value={"SMAP\nDeciderAndAggregateTypeConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeciderAndAggregateTypeConfigurator.kt\ndk/cloudcreate/essentials/components/kotlin/eventsourcing/adapters/DeciderAndAggregateTypeConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n1549#2:153\n1620#2,3:154\n1855#2:157\n766#2:158\n857#2,2:159\n1549#2:161\n1620#2,3:162\n1856#2:165\n*S KotlinDebug\n*F\n+ 1 DeciderAndAggregateTypeConfigurator.kt\ndk/cloudcreate/essentials/components/kotlin/eventsourcing/adapters/DeciderAndAggregateTypeConfigurator\n*L\n73#1:151,2\n107#1:153\n107#1:154,3\n110#1:157\n111#1:158\n111#1:159,2\n123#1:161\n123#1:162,3\n110#1:165\n*E\n"})
public final class DeciderAndAggregateTypeConfigurator {
    @NotNull
    private final ConfigurableEventStore<?> eventStore;
    @NotNull
    private final CommandBus commandBus;
    @NotNull
    private final List<AggregateTypeConfiguration> aggregateTypeConfigurations;
    @NotNull
    private final List<Decider<?, ?>> deciders;
    private final Logger log;

    public DeciderAndAggregateTypeConfigurator(@NotNull ConfigurableEventStore<?> eventStore, @NotNull CommandBus commandBus, @NotNull List<AggregateTypeConfiguration> aggregateTypeConfigurations, @NotNull List<? extends Decider<?, ?>> deciders) {
        Intrinsics.checkNotNullParameter(eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter(aggregateTypeConfigurations, (String)"aggregateTypeConfigurations");
        Intrinsics.checkNotNullParameter(deciders, (String)"deciders");
        this.eventStore = eventStore;
        this.commandBus = commandBus;
        this.aggregateTypeConfigurations = aggregateTypeConfigurations;
        this.deciders = deciders;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.addAggregateTypeConfigurationsToTheEventStore();
        this.registerDecidersAsCommandHandlersOnTheCommandBus();
    }

    private final void addAggregateTypeConfigurationsToTheEventStore() {
        this.log.info("Registering {} {}(s) with the EventStore", (Object)this.aggregateTypeConfigurations.size(), (Object)Reflection.getOrCreateKotlinClass(AggregateTypeConfiguration.class).getSimpleName());
        Iterable $this$forEach$iv = this.aggregateTypeConfigurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AggregateTypeConfiguration it = (AggregateTypeConfiguration)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(AggregateTypeConfiguration.class).getSimpleName(), it.getAggregateType(), it.getAggregateIdType().getSimpleName()};
            this.log.info("    \n============================================================================================================================================================================================\nRegistering {} for '{}' with aggregateType '{}' to the EventStore\n============================================================================================================================================================================================", objectArray);
            this.eventStore.addAggregateEventStreamConfiguration(it.getAggregateType(), it.getAggregateIdSerializer());
            this.log.info("============================================================================================================================================================================================");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerDecidersAsCommandHandlersOnTheCommandBus() {
        Iterable it;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new Object[5];
        objectArray[0] = this.deciders.size();
        objectArray[1] = Reflection.getOrCreateKotlinClass(Decider.class).getSimpleName();
        objectArray[2] = Reflection.getOrCreateKotlinClass(CommandHandler.class).getSimpleName();
        objectArray[3] = Reflection.getOrCreateKotlinClass(this.commandBus.getClass()).getSimpleName();
        Iterable iterable = this.deciders;
        int n = 4;
        Object[] objectArray2 = objectArray;
        String string = "    \n============================================================================================================================================================================================    \nRegistering {} {}(s) as {}(s) on the {}\n{}\n============================================================================================================================================================================================";
        Logger logger = this.log;
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Decider decider = (Decider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName());
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        logger.info(string, objectArray);
        Iterable $this$forEach$iv = this.deciders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AggregateTypeConfiguration it2;
            void $this$filterTo$iv$iv;
            Decider decider = (Decider)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.aggregateTypeConfigurations;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (AggregateTypeConfiguration)element$iv$iv;
                boolean bl2 = false;
                if (!it2.getDeciderSupportsAggregateTypeChecker().doesDeciderWorkWithThisAggregateType(decider)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List matchingAggregateTypes = (List)destination$iv$iv2;
            if (matchingAggregateTypes.isEmpty()) {
                throw new IllegalStateException("Couldn't resolve which " + Reflection.getOrCreateKotlinClass(AggregateType.class).getSimpleName() + " that " + Reflection.getOrCreateKotlinClass(Decider.class).getSimpleName() + " '" + Reflection.getOrCreateKotlinClass(decider.getClass()).getQualifiedName() + "' works with");
            }
            if (matchingAggregateTypes.size() > 1) {
                Collection<AggregateType> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                $this$filter$iv = matchingAggregateTypes;
                String string2 = Reflection.getOrCreateKotlinClass(decider.getClass()).getQualifiedName();
                String string3 = Reflection.getOrCreateKotlinClass(Decider.class).getSimpleName();
                String string4 = Reflection.getOrCreateKotlinClass(AggregateType.class).getSimpleName();
                int n2 = matchingAggregateTypes.size();
                boolean $i$f$map2 = false;
                $this$filterTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (AggregateTypeConfiguration)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(it2.getAggregateType());
                }
                collection2 = (List)destination$iv$iv2;
                String string5 = "Resolved " + n2 + " " + string4 + "(s) that " + string3 + " '" + string2 + "' works with: " + (List)collection2;
                throw new IllegalStateException(string5);
            }
            Object[] objectArray3 = new Object[]{Reflection.getOrCreateKotlinClass(Decider.class).getSimpleName(), decider.getClass().getName(), Reflection.getOrCreateKotlinClass(CommandHandler.class).getSimpleName(), Reflection.getOrCreateKotlinClass(DeciderCommandHandlerAdapter.class).getSimpleName(), GenericType.resolveGenericTypeForInterface(decider.getClass(), Decider.class, (int)0), Reflection.getOrCreateKotlinClass(this.commandBus.getClass()).getSimpleName()};
            this.log.info("Registering {} '{}' as {}, wrapped in a {}, handling command '{}' (CommandBus: {})", objectArray3);
            this.commandBus.addCommandHandler((CommandHandler)new DeciderCommandHandlerAdapter(decider, (AggregateTypeConfiguration)CollectionsKt.first((List)matchingAggregateTypes), (EventStore)this.eventStore));
            this.log.info("============================================================================================================================================================================================");
        }
    }
}

