/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.jackson.immutable;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.Reflector;
import java.io.IOException;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public final class ImmutableObjectsValueInstantiator
extends ValueInstantiator {
    private static Objenesis OBJENESIS = new ObjenesisStd();
    private final ValueInstantiator standardJacksonValueInstantiator;
    private final ObjectInstantiator<?> objenesisInstantiator;

    public ImmutableObjectsValueInstantiator(Class<?> typeToInstantiate, ValueInstantiator defaultJacksonInstantiator) {
        FailFast.requireNonNull(typeToInstantiate, (String)"You must provide a typeToInstantiate instance");
        this.objenesisInstantiator = OBJENESIS.getInstantiatorOf(typeToInstantiate);
        this.standardJacksonValueInstantiator = (ValueInstantiator)FailFast.requireNonNull((Object)defaultJacksonInstantiator, (String)"You must provide a standardJacksonValueInstantiator instance");
    }

    public boolean canCreateUsingDefault() {
        return true;
    }

    public Object createUsingDefault(DeserializationContext context) throws IOException {
        boolean isTheStandardValueInstantiatorCapableOfCreatingANewInstance = this.standardJacksonValueInstantiator.canCreateUsingDefault();
        if (isTheStandardValueInstantiatorCapableOfCreatingANewInstance) {
            return this.standardJacksonValueInstantiator.createUsingDefault(context);
        }
        return this.objenesisInstantiator.newInstance();
    }

    public Class<?> getValueClass() {
        return this.standardJacksonValueInstantiator.getValueClass();
    }

    public String getValueTypeDesc() {
        return this.standardJacksonValueInstantiator.getValueTypeDesc();
    }

    public boolean canInstantiate() {
        return this.standardJacksonValueInstantiator.canInstantiate();
    }

    public boolean canCreateFromString() {
        return this.standardJacksonValueInstantiator.canCreateFromString();
    }

    public boolean canCreateFromInt() {
        return this.standardJacksonValueInstantiator.canCreateFromInt();
    }

    public boolean canCreateFromLong() {
        return this.standardJacksonValueInstantiator.canCreateFromLong();
    }

    public boolean canCreateFromDouble() {
        return this.standardJacksonValueInstantiator.canCreateFromDouble();
    }

    public boolean canCreateFromBoolean() {
        return this.standardJacksonValueInstantiator.canCreateFromBoolean();
    }

    public boolean canCreateUsingDelegate() {
        return this.standardJacksonValueInstantiator.canCreateUsingDelegate();
    }

    public boolean canCreateUsingArrayDelegate() {
        return this.standardJacksonValueInstantiator.canCreateUsingArrayDelegate();
    }

    public boolean canCreateFromObjectWith() {
        return this.standardJacksonValueInstantiator.canCreateFromObjectWith();
    }

    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        return this.standardJacksonValueInstantiator.getFromObjectArguments(config);
    }

    public JavaType getDelegateType(DeserializationConfig config) {
        return this.standardJacksonValueInstantiator.getDelegateType(config);
    }

    public JavaType getArrayDelegateType(DeserializationConfig config) {
        return this.standardJacksonValueInstantiator.getArrayDelegateType(config);
    }

    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
        return this.standardJacksonValueInstantiator.createFromObjectWith(ctxt, args);
    }

    public Object createFromObjectWith(DeserializationContext ctxt, SettableBeanProperty[] props, PropertyValueBuffer buffer) throws IOException {
        return this.standardJacksonValueInstantiator.createFromObjectWith(ctxt, props, buffer);
    }

    public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) throws IOException {
        return this.standardJacksonValueInstantiator.createUsingDelegate(ctxt, delegate);
    }

    public Object createUsingArrayDelegate(DeserializationContext ctxt, Object delegate) throws IOException {
        return this.standardJacksonValueInstantiator.createUsingArrayDelegate(ctxt, delegate);
    }

    public Object createFromString(DeserializationContext ctxt, String value) throws IOException {
        return this.standardJacksonValueInstantiator.createFromString(ctxt, value);
    }

    public Object createFromInt(DeserializationContext ctxt, int value) throws IOException {
        return this.standardJacksonValueInstantiator.createFromInt(ctxt, value);
    }

    public Object createFromLong(DeserializationContext ctxt, long value) throws IOException {
        return this.standardJacksonValueInstantiator.createFromLong(ctxt, value);
    }

    public Object createFromDouble(DeserializationContext ctxt, double value) throws IOException {
        return this.standardJacksonValueInstantiator.createFromDouble(ctxt, value);
    }

    public Object createFromBoolean(DeserializationContext ctxt, boolean value) throws IOException {
        return this.standardJacksonValueInstantiator.createFromBoolean(ctxt, value);
    }

    public AnnotatedWithParams getDefaultCreator() {
        return this.standardJacksonValueInstantiator.getDefaultCreator();
    }

    public AnnotatedWithParams getDelegateCreator() {
        return this.standardJacksonValueInstantiator.getDelegateCreator();
    }

    public AnnotatedWithParams getArrayDelegateCreator() {
        return this.standardJacksonValueInstantiator.getArrayDelegateCreator();
    }

    public AnnotatedWithParams getWithArgsCreator() {
        return this.standardJacksonValueInstantiator.getWithArgsCreator();
    }

    protected Object _createFromStringFallbacks(DeserializationContext ctxt, String value) throws IOException {
        return Reflector.reflectOn(this.standardJacksonValueInstantiator.getClass()).invoke("_createFromStringFallbacks", (Object)this.standardJacksonValueInstantiator, new Object[]{ctxt, value});
    }
}

