/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.jackson.immutable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import dk.cloudcreate.essentials.jackson.immutable.ImmutableObjectsValueInstantiator;
import dk.cloudcreate.essentials.shared.FailFast;

public final class EssentialsImmutableJacksonModule
extends SimpleModule {
    public EssentialsImmutableJacksonModule() {
        super("Essentials-Immutable");
    }

    public void setupModule(Module.SetupContext context) {
        context.addBeanDeserializerModifier(new BeanDeserializerModifier(){

            public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
                builder.setValueInstantiator((ValueInstantiator)new ImmutableObjectsValueInstantiator(beanDesc.getBeanClass(), builder.getValueInstantiator()));
                return builder;
            }
        });
        super.setupModule(context);
    }

    public static ObjectMapper createObjectMapper(Module ... additionalModules) {
        FailFast.requireNonNull((Object)additionalModules, (String)"additionalModules is null");
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().visibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY).withCreatorVisibility(JsonAutoDetect.Visibility.ANY))).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_GETTERS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS})).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS})).disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS})).enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS})).enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).addModule((Module)new EssentialsImmutableJacksonModule())).addModules(additionalModules)).build();
    }
}

