/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.immutable;

import dk.cloudcreate.essentials.immutable.Immutable;
import dk.cloudcreate.essentials.immutable.annotations.Exclude;
import dk.cloudcreate.essentials.shared.functional.tuple.Pair;
import dk.cloudcreate.essentials.shared.functional.tuple.Tuple;
import dk.cloudcreate.essentials.shared.reflection.Reflector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ImmutableValueObject
implements Immutable {
    private transient Integer hashCode;
    private transient String toString;
    private transient List<Field> equalsAndHashCodeFields;

    public int hashCode() {
        if (this.hashCode == null) {
            Reflector reflector = Reflector.reflectOn(this.getClass());
            this.hashCode = this.equalsAndHashCodeIncludedFields(reflector).stream().map(field -> reflector.get((Object)this, field)).map(fieldValue -> fieldValue == null ? 0 : fieldValue.hashCode()).reduce(1, (result, elementHashCode) -> 31 * result + elementHashCode);
        }
        return this.hashCode;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        Reflector reflector = Reflector.reflectOn(this.getClass());
        for (Field field : this.equalsAndHashCodeIncludedFields(reflector)) {
            Object thatFieldValue;
            Object thisFieldValue = reflector.get((Object)this, field);
            if (Objects.equals(thisFieldValue, thatFieldValue = reflector.get(that, field))) continue;
            return false;
        }
        return true;
    }

    private List<Field> equalsAndHashCodeIncludedFields(Reflector reflector) {
        if (this.equalsAndHashCodeFields == null) {
            this.equalsAndHashCodeFields = reflector.fields.stream().filter(field -> !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())).filter(field -> !field.isAnnotationPresent(Exclude.EqualsAndHashCode.class)).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        }
        return this.equalsAndHashCodeFields;
    }

    public String toString() {
        if (this.toString == null) {
            List<Pair> nullFields;
            Reflector reflector = Reflector.reflectOn(this.getClass());
            Map<Boolean, List<Pair>> nonNullVsNullFieldValues = reflector.fields.stream().filter(field -> !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())).filter(field -> !field.isAnnotationPresent(Exclude.ToString.class)).map(field -> Tuple.of((Object)field.getName(), (Object)reflector.get((Object)this, field))).collect(Collectors.groupingBy(fieldNameAndValue -> fieldNameAndValue._2 != null));
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" { ");
            List<Pair> nonNullFields = nonNullVsNullFieldValues.get(true);
            if (nonNullFields != null) {
                builder.append(nonNullFields.stream().sorted(Comparator.comparing(fieldNameAndValue -> (String)fieldNameAndValue._1)).map(fieldNameAndValue -> (String)fieldNameAndValue._1 + ": " + fieldNameAndValue._2.toString()).reduce((result, element) -> result + ", " + element).get());
            }
            if ((nullFields = nonNullVsNullFieldValues.get(false)) != null) {
                if (nonNullFields != null) {
                    builder.append(", ");
                }
                builder.append(nullFields.stream().sorted(Comparator.comparing(fieldNameAndValue -> (String)fieldNameAndValue._1)).map(fieldNameAndValue -> (String)fieldNameAndValue._1 + ": null").reduce((result, element) -> result + ", " + element).get());
            }
            builder.append(" }");
            this.toString = builder.toString();
        }
        return this.toString;
    }
}

