/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command;

import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Mono;

public interface CommandBus {
    public List<CommandBusInterceptor> getInterceptors();

    public CommandBus addInterceptor(CommandBusInterceptor var1);

    default public CommandBus addInterceptors(List<CommandBusInterceptor> interceptors) {
        FailFast.requireNonNull(interceptors, (String)"No interceptors list provided");
        interceptors.forEach(this::addInterceptor);
        return this;
    }

    public boolean hasInterceptor(CommandBusInterceptor var1);

    public CommandBus removeInterceptor(CommandBusInterceptor var1);

    public CommandBus addCommandHandler(CommandHandler var1);

    public CommandBus removeCommandHandler(CommandHandler var1);

    public <R, C> R send(C var1);

    public <R, C> Mono<R> sendAsync(C var1);

    public <C> void sendAndDontWait(C var1);

    public <C> void sendAndDontWait(C var1, Duration var2);

    public CommandHandler findCommandHandlerCapableOfHandling(Object var1);

    public boolean hasCommandHandler(CommandHandler var1);
}

