/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command;

import dk.cloudcreate.essentials.reactive.command.CommandBus;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.MultipleCommandHandlersFoundException;
import dk.cloudcreate.essentials.reactive.command.NoCommandHandlerFoundException;
import dk.cloudcreate.essentials.reactive.command.SendAndDontWaitErrorHandler;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptorChain;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.interceptor.DefaultInterceptorChain;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public abstract class AbstractCommandBus
implements CommandBus {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final List<CommandBusInterceptor> interceptors = new CopyOnWriteArrayList<CommandBusInterceptor>();
    protected final Set<CommandHandler> commandHandlers = new HashSet<CommandHandler>();
    protected final SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler;
    protected final ConcurrentMap<Class<?>, CommandHandler> commandTypeToCommandHandlerCache = new ConcurrentHashMap();

    protected AbstractCommandBus(List<CommandBusInterceptor> interceptors) {
        this(new SendAndDontWaitErrorHandler.FallbackSendAndDontWaitErrorHandler(), interceptors);
    }

    protected AbstractCommandBus(SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, List<CommandBusInterceptor> interceptors) {
        FailFast.requireNonNull(interceptors, (String)"No interceptors list provided");
        this.sendAndDontWaitErrorHandler = (SendAndDontWaitErrorHandler)FailFast.requireNonNull((Object)sendAndDontWaitErrorHandler, (String)"No sendAndDontWaitErrorHandler provided");
        interceptors.forEach(this::addInterceptor);
    }

    @Override
    public List<CommandBusInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    @Override
    public CommandBus addInterceptor(CommandBusInterceptor interceptor) {
        if (!this.interceptors.contains(interceptor)) {
            this.log.info("Adding CommandBusInterceptor: {}", (Object)interceptor);
            this.interceptors.add((CommandBusInterceptor)FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided"));
        }
        DefaultInterceptorChain.sortInterceptorsByOrder(this.interceptors);
        return this;
    }

    @Override
    public boolean hasInterceptor(CommandBusInterceptor interceptor) {
        return this.interceptors.contains(FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided"));
    }

    @Override
    public CommandBus removeInterceptor(CommandBusInterceptor interceptor) {
        this.log.info("Removing CommandBusInterceptor: {}", (Object)interceptor);
        this.interceptors.remove(FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided"));
        DefaultInterceptorChain.sortInterceptorsByOrder(this.interceptors);
        return this;
    }

    @Override
    public CommandBus addCommandHandler(CommandHandler commandHandler) {
        if (!this.hasCommandHandler(commandHandler)) {
            this.log.info("Adding CommandHandler: {}", (Object)commandHandler);
            if (this.commandHandlers.add((CommandHandler)FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"))) {
                this.commandTypeToCommandHandlerCache.clear();
            }
        }
        return this;
    }

    @Override
    public CommandBus removeCommandHandler(CommandHandler commandHandler) {
        this.log.info("Removing CommandHandler: {}", (Object)commandHandler);
        if (this.commandHandlers.remove(FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"))) {
            this.commandTypeToCommandHandlerCache.clear();
        }
        return this;
    }

    @Override
    public <R, C> R send(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        this.log.debug("Synchronously sending command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        return (R)CommandBusInterceptorChain.newInterceptorChain(command, commandHandler, this.interceptors, (interceptor, commandBusInterceptorChain) -> interceptor.interceptSend(command, (CommandBusInterceptorChain)commandBusInterceptorChain), commandHandler::handle).proceed();
    }

    @Override
    public <R, C> Mono<R> sendAsync(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        this.log.debug("Asynchronously sending command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        return Mono.fromCallable(() -> CommandBusInterceptorChain.newInterceptorChain(command, commandHandler, this.interceptors, (interceptor, commandBusInterceptorChain) -> interceptor.interceptSendAsync(command, (CommandBusInterceptorChain)commandBusInterceptorChain), commandHandler::handle).proceed()).publishOn(Schedulers.boundedElastic());
    }

    @Override
    public CommandHandler findCommandHandlerCapableOfHandling(Object command) {
        FailFast.requireNonNull((Object)command, (String)"No command provided");
        return this.commandTypeToCommandHandlerCache.computeIfAbsent(command.getClass(), commandType -> {
            List commandHandlersThatCanHandleCommand = this.commandHandlers.stream().filter(commandHandler -> commandHandler.canHandle((Class<?>)commandType)).collect(Collectors.toList());
            if (commandHandlersThatCanHandleCommand.isEmpty()) {
                throw new NoCommandHandlerFoundException((Class<?>)commandType, MessageFormatter.msg((String)"Couldn't find a {} that can handle a command of type '{}'", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandType.getName()}));
            }
            if (commandHandlersThatCanHandleCommand.size() > 1) {
                throw new MultipleCommandHandlersFoundException((Class<?>)commandType, MessageFormatter.msg((String)"There should only be one {} that can handle a given command. Found {} {}'s that all can handle a command of type '{}': {}", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandHandlersThatCanHandleCommand.size(), CommandHandler.class.getSimpleName(), commandType.getName(), commandHandlersThatCanHandleCommand.stream().map(Object::toString).collect(Collectors.toList())}));
            }
            return (CommandHandler)commandHandlersThatCanHandleCommand.get(0);
        });
    }

    @Override
    public boolean hasCommandHandler(CommandHandler commandHandler) {
        return this.commandHandlers.contains(FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"));
    }

    public String toString() {
        return this.getClass().getName() + "{interceptors=" + this.interceptors + ", commandHandlers=" + this.commandHandlers + "}";
    }
}

