/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.spring;

import dk.cloudcreate.essentials.reactive.EventBus;
import dk.cloudcreate.essentials.reactive.EventHandler;
import dk.cloudcreate.essentials.reactive.LocalEventBus;
import dk.cloudcreate.essentials.reactive.command.CommandBus;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.LocalCommandBus;
import dk.cloudcreate.essentials.reactive.spring.AsyncEventHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ReactiveHandlersBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ReactiveHandlersBeanPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private Collection<EventBus> eventBus;
    private CommandBus commandBus;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.shouldSkipPostProcessing(bean, beanName)) {
            log.debug("Skipping post-processing of bean '{}'", (Object)beanName);
            return bean;
        }
        if (this.isEventHandler(bean)) {
            Class<?> actualHandlerClass = this.resolveBeanClass(bean);
            if (actualHandlerClass.isAnnotationPresent(AsyncEventHandler.class)) {
                log.debug("Adding asynchronous event handler '{}' of type '{}' to the {}", new Object[]{beanName, actualHandlerClass.getName(), LocalEventBus.class.getSimpleName()});
                this.eventBusses().forEach(eventBus -> eventBus.addAsyncSubscriber((EventHandler)bean));
            } else {
                log.debug("Adding synchronous event handler '{}' of type '{}' to the {}", new Object[]{beanName, actualHandlerClass.getName(), LocalEventBus.class.getSimpleName()});
                this.eventBusses().forEach(eventBus -> eventBus.addSyncSubscriber((EventHandler)bean));
            }
        } else if (this.isCommandHandler(bean)) {
            Class<?> actualHandlerClass = this.resolveBeanClass(bean);
            log.debug("Adding command handler '{}' of type '{}' to the {}", new Object[]{beanName, actualHandlerClass.getName(), LocalCommandBus.class.getSimpleName()});
            this.commandBus().addCommandHandler((CommandHandler)bean);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.isEventHandler(bean)) {
            Class<?> actualHandlerClass = this.resolveBeanClass(bean);
            if (actualHandlerClass.isAnnotationPresent(AsyncEventHandler.class)) {
                this.eventBusses().forEach(eventBus -> eventBus.removeAsyncSubscriber((EventHandler)bean));
            } else {
                this.eventBusses().forEach(eventBus -> eventBus.removeSyncSubscriber((EventHandler)bean));
            }
        } else if (this.isCommandHandler(bean)) {
            this.commandBus().removeCommandHandler((CommandHandler)bean);
        }
    }

    public boolean requiresDestruction(Object bean) {
        return this.isReactiveHandler(bean);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        }
    }

    private boolean shouldSkipPostProcessing(Object bean, String beanName) {
        if (this.beanFactory != null) {
            try {
                BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
                if (beanDefinition.getRole() == 2 || bean.getClass().isAnnotationPresent(AutoConfiguration.class)) {
                    return true;
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return false;
    }

    private Collection<EventBus> eventBusses() {
        if (this.eventBus == null) {
            this.eventBus = this.applicationContext.getBeansOfType(EventBus.class).values();
        }
        return this.eventBus;
    }

    private CommandBus commandBus() {
        if (this.commandBus == null) {
            this.commandBus = (CommandBus)this.applicationContext.getBean(CommandBus.class);
        }
        return this.commandBus;
    }

    private boolean isReactiveHandler(Object bean) {
        Class<?> actualBeanClass = this.resolveBeanClass(bean);
        return EventHandler.class.isAssignableFrom(actualBeanClass) || CommandHandler.class.isAssignableFrom(actualBeanClass);
    }

    private boolean isEventHandler(Object bean) {
        Class<?> actualBeanClass = this.resolveBeanClass(bean);
        return EventHandler.class.isAssignableFrom(actualBeanClass);
    }

    private boolean isCommandHandler(Object bean) {
        Class<?> actualBeanClass = this.resolveBeanClass(bean);
        return CommandHandler.class.isAssignableFrom(actualBeanClass);
    }

    private Class<?> resolveBeanClass(Object bean) {
        return AopUtils.getTargetClass((Object)bean);
    }
}

