/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command;

import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.MultipleCommandHandlersFoundException;
import dk.cloudcreate.essentials.reactive.command.NoCommandHandlerFoundException;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class LocalCommandBus {
    private static final Logger log = LoggerFactory.getLogger(LocalCommandBus.class);
    private final Set<CommandHandler> commandHandlers = new HashSet<CommandHandler>();
    private final ConcurrentMap<Class<?>, CommandHandler> commandTypeToCommandHandlerCache = new ConcurrentHashMap();

    public LocalCommandBus addCommandHandler(CommandHandler commandHandler) {
        log.info("Adding CommandHandler: {}", (Object)commandHandler);
        if (this.commandHandlers.add((CommandHandler)FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"))) {
            this.commandTypeToCommandHandlerCache.clear();
        }
        return this;
    }

    public LocalCommandBus removeCommandHandler(CommandHandler commandHandler) {
        log.info("Removing CommandHandler: {}", (Object)commandHandler);
        if (this.commandHandlers.remove(FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"))) {
            this.commandTypeToCommandHandlerCache.clear();
        }
        return this;
    }

    public <R, C> R send(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        log.debug("Synchronously sending command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        return (R)commandHandler.handle(command);
    }

    public <R, C> Mono<R> sendAsync(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        log.debug("Asynchronously sending command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        return Mono.fromCallable(() -> commandHandler.handle(command)).publishOn(Schedulers.boundedElastic());
    }

    protected CommandHandler findCommandHandlerCapableOfHandling(Object command) {
        FailFast.requireNonNull((Object)command, (String)"No command provided");
        return this.commandTypeToCommandHandlerCache.computeIfAbsent(command.getClass(), commandType -> {
            List commandHandlersThatCanHandleCommand = this.commandHandlers.stream().filter(commandHandler -> commandHandler.canHandle((Class<?>)commandType)).collect(Collectors.toList());
            if (commandHandlersThatCanHandleCommand.isEmpty()) {
                throw new NoCommandHandlerFoundException((Class<?>)commandType, MessageFormatter.msg((String)"Couldn't find a {} that can handle a command of type '{}'", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandType.getName()}));
            }
            if (commandHandlersThatCanHandleCommand.size() > 1) {
                throw new MultipleCommandHandlersFoundException((Class<?>)commandType, MessageFormatter.msg((String)"There should only be one {} that can handle a given command. Found {} {}'s that all can handle a command of type '{}': {}", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandHandlersThatCanHandleCommand.size(), CommandHandler.class.getSimpleName(), commandType.getName(), commandHandlersThatCanHandleCommand.stream().map(Object::toString).collect(Collectors.toList())}));
            }
            return (CommandHandler)commandHandlersThatCanHandleCommand.get(0);
        });
    }

    public boolean hasCommandHandler(CommandHandler commandHandler) {
        return this.commandHandlers.contains(commandHandler);
    }
}

