/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command;

import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.MultipleCommandHandlersFoundException;
import dk.cloudcreate.essentials.reactive.command.NoCommandHandlerFoundException;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptorChain;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class LocalCommandBus {
    private static final Logger log = LoggerFactory.getLogger(LocalCommandBus.class);
    private final List<CommandBusInterceptor> interceptors = new ArrayList<CommandBusInterceptor>();
    private final Set<CommandHandler> commandHandlers = new HashSet<CommandHandler>();
    private final ConcurrentMap<Class<?>, CommandHandler> commandTypeToCommandHandlerCache = new ConcurrentHashMap();

    public LocalCommandBus() {
        this(List.of());
    }

    public LocalCommandBus(List<CommandBusInterceptor> interceptors) {
        FailFast.requireNonNull(interceptors, (String)"No interceptors list provided");
        interceptors.forEach(this::addInterceptor);
    }

    public LocalCommandBus(CommandBusInterceptor ... interceptors) {
        this(List.of(interceptors));
    }

    public List<CommandBusInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public LocalCommandBus addInterceptor(CommandBusInterceptor interceptor) {
        if (!this.interceptors.contains(interceptor)) {
            log.info("Adding CommandBusInterceptor: {}", (Object)interceptor);
            this.interceptors.add((CommandBusInterceptor)FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided"));
        }
        return this;
    }

    public boolean hasInterceptor(CommandBusInterceptor interceptor) {
        return this.interceptors.contains(FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided"));
    }

    public LocalCommandBus removeInterceptor(CommandBusInterceptor interceptor) {
        log.info("Removing CommandBusInterceptor: {}", (Object)interceptor);
        this.interceptors.remove(FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided"));
        return this;
    }

    public LocalCommandBus addCommandHandler(CommandHandler commandHandler) {
        if (!this.hasCommandHandler(commandHandler)) {
            log.info("Adding CommandHandler: {}", (Object)commandHandler);
            if (this.commandHandlers.add((CommandHandler)FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"))) {
                this.commandTypeToCommandHandlerCache.clear();
            }
        }
        return this;
    }

    public LocalCommandBus removeCommandHandler(CommandHandler commandHandler) {
        log.info("Removing CommandHandler: {}", (Object)commandHandler);
        if (this.commandHandlers.remove(FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"))) {
            this.commandTypeToCommandHandlerCache.clear();
        }
        return this;
    }

    public <R, C> R send(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        log.debug("Synchronously sending command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        return (R)CommandBusInterceptorChain.newInterceptorChain(command, commandHandler, this.interceptors, (interceptor, commandBusInterceptorChain) -> interceptor.interceptSend(command, (CommandBusInterceptorChain)commandBusInterceptorChain), commandHandler::handle).proceed();
    }

    public <R, C> Mono<R> sendAsync(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        log.debug("Asynchronously sending command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        return Mono.fromCallable(() -> CommandBusInterceptorChain.newInterceptorChain(command, commandHandler, this.interceptors, (interceptor, commandBusInterceptorChain) -> interceptor.interceptSendAsync(command, (CommandBusInterceptorChain)commandBusInterceptorChain), commandHandler::handle).proceed()).publishOn(Schedulers.boundedElastic());
    }

    public <C> void sendAndDontWait(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        log.debug("Asynchronously sending command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        Mono.fromCallable(() -> CommandBusInterceptorChain.newInterceptorChain(command, commandHandler, this.interceptors, (interceptor, commandBusInterceptorChain) -> {
            interceptor.interceptSendAndDontWait(command, (CommandBusInterceptorChain)commandBusInterceptorChain);
            return null;
        }, commandHandler::handle).proceed()).publishOn(Schedulers.boundedElastic()).subscribe();
    }

    public CommandHandler findCommandHandlerCapableOfHandling(Object command) {
        FailFast.requireNonNull((Object)command, (String)"No command provided");
        return this.commandTypeToCommandHandlerCache.computeIfAbsent(command.getClass(), commandType -> {
            List commandHandlersThatCanHandleCommand = this.commandHandlers.stream().filter(commandHandler -> commandHandler.canHandle((Class<?>)commandType)).collect(Collectors.toList());
            if (commandHandlersThatCanHandleCommand.isEmpty()) {
                throw new NoCommandHandlerFoundException((Class<?>)commandType, MessageFormatter.msg((String)"Couldn't find a {} that can handle a command of type '{}'", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandType.getName()}));
            }
            if (commandHandlersThatCanHandleCommand.size() > 1) {
                throw new MultipleCommandHandlersFoundException((Class<?>)commandType, MessageFormatter.msg((String)"There should only be one {} that can handle a given command. Found {} {}'s that all can handle a command of type '{}': {}", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandHandlersThatCanHandleCommand.size(), CommandHandler.class.getSimpleName(), commandType.getName(), commandHandlersThatCanHandleCommand.stream().map(Object::toString).collect(Collectors.toList())}));
            }
            return (CommandHandler)commandHandlersThatCanHandleCommand.get(0);
        });
    }

    public boolean hasCommandHandler(CommandHandler commandHandler) {
        return this.commandHandlers.contains(FailFast.requireNonNull((Object)commandHandler, (String)"No commandHandler provided"));
    }

    public String toString() {
        return "LocalCommandBus{interceptors=" + this.interceptors + ", commandHandlers=" + this.commandHandlers + "}";
    }
}

