/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.spring;

import dk.cloudcreate.essentials.reactive.EventHandler;
import dk.cloudcreate.essentials.reactive.LocalEventBus;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.LocalCommandBus;
import dk.cloudcreate.essentials.reactive.spring.AsyncEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReactiveHandlersBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ReactiveHandlersBeanPostProcessor.class);
    private ApplicationContext applicationContext;
    private LocalEventBus eventBus;
    private LocalCommandBus commandBus;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.isEventHandler(bean)) {
            Class<?> actualHandlerClass = this.resolveBeanClass(bean);
            if (actualHandlerClass.isAnnotationPresent(AsyncEventHandler.class)) {
                log.debug("Adding asynchronous event handler '{}' of type '{}' to the {}", new Object[]{beanName, actualHandlerClass.getName(), LocalEventBus.class.getSimpleName()});
                this.eventBus().addAsyncSubscriber((EventHandler)bean);
            } else {
                log.debug("Adding synchronous event handler '{}' of type '{}' to the {}", new Object[]{beanName, actualHandlerClass.getName(), LocalEventBus.class.getSimpleName()});
                this.eventBus().addSyncSubscriber((EventHandler)bean);
            }
        } else if (this.isCommandHandler(bean)) {
            Class<?> actualHandlerClass = this.resolveBeanClass(bean);
            log.debug("Adding command handler '{}' of type '{}' to the {}", new Object[]{beanName, actualHandlerClass.getName(), LocalCommandBus.class.getSimpleName()});
            this.commandBus().addCommandHandler((CommandHandler)bean);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.isEventHandler(bean)) {
            Class<?> actualHandlerClass = this.resolveBeanClass(bean);
            if (actualHandlerClass.isAnnotationPresent(AsyncEventHandler.class)) {
                this.eventBus().removeAsyncSubscriber((EventHandler)bean);
            } else {
                this.eventBus().removeSyncSubscriber((EventHandler)bean);
            }
        } else if (this.isCommandHandler(bean)) {
            this.commandBus().removeCommandHandler((CommandHandler)bean);
        }
    }

    public boolean requiresDestruction(Object bean) {
        return this.isReactiveHandler(bean);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private LocalEventBus eventBus() {
        if (this.eventBus == null) {
            this.eventBus = (LocalEventBus)this.applicationContext.getBean(LocalEventBus.class);
        }
        return this.eventBus;
    }

    private LocalCommandBus commandBus() {
        if (this.commandBus == null) {
            this.commandBus = (LocalCommandBus)this.applicationContext.getBean(LocalCommandBus.class);
        }
        return this.commandBus;
    }

    private boolean isReactiveHandler(Object bean) {
        Class<?> actualBeanClass = this.resolveBeanClass(bean);
        return EventHandler.class.isAssignableFrom(actualBeanClass) || CommandHandler.class.isAssignableFrom(actualBeanClass);
    }

    private boolean isEventHandler(Object bean) {
        Class<?> actualBeanClass = this.resolveBeanClass(bean);
        return EventHandler.class.isAssignableFrom(actualBeanClass);
    }

    private boolean isCommandHandler(Object bean) {
        Class<?> actualBeanClass = this.resolveBeanClass(bean);
        return CommandHandler.class.isAssignableFrom(actualBeanClass);
    }

    private Class<?> resolveBeanClass(Object bean) {
        return AopUtils.getTargetClass((Object)bean);
    }
}

