/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command;

import dk.cloudcreate.essentials.reactive.Handler;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.MultipleCommandHandlersFoundException;
import dk.cloudcreate.essentials.reactive.command.NoCommandHandlerFoundException;
import dk.cloudcreate.essentials.shared.Exceptions;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.Methods;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotatedCommandHandler
implements CommandHandler {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedCommandHandler.class);
    private final List<Method> invokableMethods;
    private final ConcurrentMap<Class<?>, Method> commandTypeToHandlerMethodCache = new ConcurrentHashMap();

    public AnnotatedCommandHandler() {
        Class<?> onClass = this.getClass();
        this.invokableMethods = Methods.methods(onClass).stream().filter(method -> method.getDeclaringClass() != Object.class).filter(candidateMethod -> candidateMethod.isAnnotationPresent(Handler.class) && candidateMethod.getParameterCount() == 1).collect(Collectors.toList());
        if (log.isTraceEnabled()) {
            log.trace("InvokableMethod in {}: {}", (Object)this.getClass().getName(), this.invokableMethods);
        }
    }

    @Override
    public boolean canHandle(Class<?> commandType) {
        return this.getHandlerMethod(commandType) != null;
    }

    @Override
    public final Object handle(Object command) {
        Class<?> commandType = command.getClass();
        Method handlerMethod = this.getHandlerMethod(commandType);
        if (handlerMethod == null) {
            throw new NoCommandHandlerFoundException(commandType, MessageFormatter.msg((String)"Couldn't find a @{} annotated method in '{}' that can handle a command of type: '{}'", (Object[])new Object[]{Handler.class.getSimpleName(), this.toString(), commandType.getName()}));
        }
        try {
            return handlerMethod.invoke((Object)this, command);
        }
        catch (InvocationTargetException e) {
            log.error(MessageFormatter.msg((String)"Failed to handle command of type {} using @{} annotated method {} in '{}'", (Object[])new Object[]{commandType.getName(), Handler.class.getSimpleName(), handlerMethod.toString(), this.toString()}), (Throwable)e);
            return Exceptions.sneakyThrow((Throwable)e.getTargetException());
        }
        catch (Exception e) {
            log.error(MessageFormatter.msg((String)"Failed to handle command of type {} using @{} annotated method {} in '{}'", (Object[])new Object[]{commandType.getName(), Handler.class.getSimpleName(), handlerMethod.toString(), this.toString()}), (Throwable)e);
            return Exceptions.sneakyThrow((Throwable)e);
        }
    }

    private Method getHandlerMethod(Class<?> commandType) {
        return this.commandTypeToHandlerMethodCache.computeIfAbsent(commandType, commandType_ -> {
            List matchingMethods = this.invokableMethods.stream().filter(method -> {
                Class<?> firstMethodArgumentType = method.getParameterTypes()[0];
                return firstMethodArgumentType.isAssignableFrom(commandType);
            }).collect(Collectors.toList());
            if (matchingMethods.isEmpty()) {
                return null;
            }
            if (matchingMethods.size() > 1) {
                throw new MultipleCommandHandlersFoundException(commandType, MessageFormatter.msg((String)"There should only be one @{} annotated method in '{}' that can handle a given command. Found {} @{} annotated methods that all can handle a command of type '{}': {}", (Object[])new Object[]{Handler.class.getSimpleName(), this.toString(), matchingMethods.size(), Handler.class.getSimpleName(), commandType.getName(), matchingMethods.stream().map(Method::toString).collect(Collectors.toList())}));
            }
            return (Method)matchingMethods.get(0);
        });
    }
}

