/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command;

import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.shared.Exceptions;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SendAndDontWaitErrorHandler {
    public void handleError(Exception var1, Object var2, CommandHandler var3);

    public static class RethrowingSendAndDontWaitErrorHandler
    implements SendAndDontWaitErrorHandler {
        private static final Logger log = LoggerFactory.getLogger(FallbackSendAndDontWaitErrorHandler.class);

        @Override
        public void handleError(Exception exception, Object command, CommandHandler commandHandler) {
            log.error(MessageFormatter.msg((String)"SendAndDontWait ERROR: {} '{}' failed to handle command: {}", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandHandler.getClass().getName(), command}), (Throwable)exception);
            Exceptions.sneakyThrow((Throwable)exception);
        }
    }

    public static class FallbackSendAndDontWaitErrorHandler
    implements SendAndDontWaitErrorHandler {
        private static final Logger log = LoggerFactory.getLogger(FallbackSendAndDontWaitErrorHandler.class);

        @Override
        public void handleError(Exception exception, Object command, CommandHandler commandHandler) {
            log.error(MessageFormatter.msg((String)"SendAndDontWait ERROR: {} '{}' failed to handle command: {}", (Object[])new Object[]{CommandHandler.class.getSimpleName(), commandHandler.getClass().getName(), command}), (Throwable)exception);
        }
    }
}

