/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command;

import dk.cloudcreate.essentials.reactive.command.AbstractCommandBus;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.SendAndDontWaitErrorHandler;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptorChain;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class LocalCommandBus
extends AbstractCommandBus {
    private static final Logger log = LoggerFactory.getLogger(LocalCommandBus.class);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(ThreadFactoryBuilder.builder().nameFormat(this.getClass().getSimpleName() + "Delayed-Send-%d").daemon(true).build());

    public LocalCommandBus() {
        super(List.of());
    }

    public LocalCommandBus(SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler) {
        super(sendAndDontWaitErrorHandler, List.of());
    }

    public LocalCommandBus(List<CommandBusInterceptor> interceptors) {
        super(interceptors);
    }

    public LocalCommandBus(SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, List<CommandBusInterceptor> interceptors) {
        super(sendAndDontWaitErrorHandler, interceptors);
    }

    public LocalCommandBus(CommandBusInterceptor ... interceptors) {
        this(List.of(interceptors));
    }

    public LocalCommandBus(SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, CommandBusInterceptor ... interceptors) {
        this(sendAndDontWaitErrorHandler, List.of(interceptors));
    }

    @Override
    public <C> void sendAndDontWait(C command) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        log.debug("sendAndDontWait command of type '{}' to {} '{}'", new Object[]{command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        Mono.fromCallable(() -> CommandBusInterceptorChain.newInterceptorChain(command, commandHandler, this.interceptors, (interceptor, commandBusInterceptorChain) -> {
            interceptor.interceptSendAndDontWait(command, (CommandBusInterceptorChain)commandBusInterceptorChain);
            return null;
        }, _cmd -> {
            try {
                return commandHandler.handle(_cmd);
            }
            catch (Exception e) {
                this.sendAndDontWaitErrorHandler.handleError(e, _cmd, commandHandler);
                return null;
            }
        }).proceed()).publishOn(Schedulers.boundedElastic()).subscribe();
    }

    @Override
    public <C> void sendAndDontWait(C command, Duration delayMessageDelivery) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        FailFast.requireNonNull((Object)delayMessageDelivery, (String)"You must provide a delayMessageDelivery value");
        log.debug("Delayed {} sendAndDontWait for command of type '{}' to {} '{}'", new Object[]{delayMessageDelivery, command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        this.scheduledExecutorService.schedule(() -> this.sendAndDontWait(command), delayMessageDelivery.toMillis(), TimeUnit.MILLISECONDS);
    }
}

