/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.reactive.command.interceptor;

import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CommandBusInterceptorChain {
    public Object proceed();

    public Object command();

    public CommandHandler matchedCommandHandler();

    public static CommandBusInterceptorChain newInterceptorChain(Object command, CommandHandler matchedCommandHandler, List<CommandBusInterceptor> interceptors, BiFunction<CommandBusInterceptor, CommandBusInterceptorChain, Object> interceptorOperationInvoker, Function<Object, Object> defaultCommandBusBehaviour) {
        return new DefaultCommandBusInterceptorChain(command, matchedCommandHandler, interceptors, interceptorOperationInvoker, defaultCommandBusBehaviour);
    }

    public static class DefaultCommandBusInterceptorChain
    implements CommandBusInterceptorChain {
        private static final Logger log = LoggerFactory.getLogger(DefaultCommandBusInterceptorChain.class);
        private final Object command;
        private CommandHandler matchedCommandHandler;
        private final Iterator<CommandBusInterceptor> interceptorsIterator;
        private final BiFunction<CommandBusInterceptor, CommandBusInterceptorChain, Object> interceptorOperationInvoker;
        private final Function<Object, Object> defaultCommandBusBehaviour;

        public DefaultCommandBusInterceptorChain(Object command, CommandHandler matchedCommandHandler, List<CommandBusInterceptor> interceptors, BiFunction<CommandBusInterceptor, CommandBusInterceptorChain, Object> interceptorOperationInvoker, Function<Object, Object> defaultCommandBusBehaviour) {
            this.command = FailFast.requireNonNull((Object)command, (String)"No command provided");
            this.matchedCommandHandler = (CommandHandler)FailFast.requireNonNull((Object)matchedCommandHandler, (String)"No matchedCommandHandler provided");
            this.interceptorsIterator = ((List)FailFast.requireNonNull(interceptors, (String)"No CommandBusInterceptor list provided")).iterator();
            this.interceptorOperationInvoker = (BiFunction)FailFast.requireNonNull(interceptorOperationInvoker, (String)"No interceptorOperationInvoker provided");
            this.defaultCommandBusBehaviour = (Function)FailFast.requireNonNull(defaultCommandBusBehaviour, (String)"No defaultCommandBusBehaviour function provided");
        }

        @Override
        public Object proceed() {
            if (this.interceptorsIterator.hasNext()) {
                CommandBusInterceptor interceptor = this.interceptorsIterator.next();
                log.trace("Invoking interceptor '{}' for Command '{}", (Object)interceptor.getClass().getName(), (Object)this.command.getClass().getName());
                return this.interceptorOperationInvoker.apply(interceptor, this);
            }
            log.trace("Invoking default CommandBus behaviour for Command '{}", (Object)this.command.getClass().getName());
            return this.defaultCommandBusBehaviour.apply(this.command);
        }

        @Override
        public Object command() {
            return this.command;
        }

        @Override
        public CommandHandler matchedCommandHandler() {
            return this.matchedCommandHandler;
        }
    }
}

