/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.collections;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Streams {
    public static <R, T, U> Stream<R> zipOrderedAndEqualSizedStreams(Stream<T> streamT, Stream<U> streamU, final BiFunction<T, U, R> zipFunction) {
        FailFast.requireNonNull(streamT, "No streamT provided");
        FailFast.requireNonNull(streamU, "No streamU provided");
        FailFast.requireNonNull(zipFunction, "No zipFunction provided");
        Spliterator streamTSpliterator = streamT.spliterator();
        if (!streamTSpliterator.hasCharacteristics(64) || !streamTSpliterator.hasCharacteristics(16)) {
            throw new IllegalArgumentException("streamT isn't a sized and ordered stream");
        }
        Spliterator streamUSpliterator = streamU.spliterator();
        if (!streamUSpliterator.hasCharacteristics(64) || !streamUSpliterator.hasCharacteristics(16)) {
            throw new IllegalArgumentException("streamU isn't a sized and ordered stream");
        }
        if (streamTSpliterator.estimateSize() != streamUSpliterator.estimateSize()) {
            throw new IllegalArgumentException(MessageFormatter.msg("Expected equal size. streamT has estimatedSize {} where as streamU has estimatedSize {}", streamTSpliterator.estimateSize(), streamUSpliterator.estimateSize()));
        }
        final Iterator streamTIterator = Spliterators.iterator(streamTSpliterator);
        final Iterator streamUIterator = Spliterators.iterator(streamUSpliterator);
        Stream zipStream = StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(Math.min(streamTSpliterator.estimateSize(), streamUSpliterator.estimateSize()), 80){

            @Override
            public boolean tryAdvance(Consumer<? super R> consumer) {
                boolean canAdvance;
                boolean bl = canAdvance = streamTIterator.hasNext() && streamUIterator.hasNext();
                if (canAdvance) {
                    consumer.accept(zipFunction.apply(streamTIterator.next(), streamUIterator.next()));
                }
                return canAdvance;
            }
        }, streamT.isParallel() || streamU.isParallel());
        return (Stream)((Stream)zipStream.onClose(streamT::close)).onClose(streamU::close);
    }
}

