/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection.invocation;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class SingleArgumentAnnotatedMethodPatternMatcher<ARGUMENT_COMMON_ROOT_TYPE>
implements MethodPatternMatcher<ARGUMENT_COMMON_ROOT_TYPE> {
    private final Class<? extends Annotation> matchOnMethodsAnnotatedWith;
    private final Class<?> argumentCommonRootType;

    public SingleArgumentAnnotatedMethodPatternMatcher(Class<? extends Annotation> matchOnMethodsAnnotatedWith, Class<ARGUMENT_COMMON_ROOT_TYPE> argumentCommonRootType) {
        this.matchOnMethodsAnnotatedWith = FailFast.requireNonNull(matchOnMethodsAnnotatedWith, "You must provide an Annotation that invokable methods are annotated with");
        this.argumentCommonRootType = FailFast.requireNonNull(argumentCommonRootType, "You must provide an argumentCommonRootType value");
    }

    public SingleArgumentAnnotatedMethodPatternMatcher(Class<? extends Annotation> matchOnMethodsAnnotatedWith, GenericType<ARGUMENT_COMMON_ROOT_TYPE> argumentCommonRootType) {
        this.matchOnMethodsAnnotatedWith = FailFast.requireNonNull(matchOnMethodsAnnotatedWith, "You must provide an Annotation that invokable methods are annotated with");
        this.argumentCommonRootType = FailFast.requireNonNull(argumentCommonRootType, "You must provide an argumentCommonRootType value").getType();
    }

    @Override
    public boolean isInvokableMethod(Method candidateMethod) {
        FailFast.requireNonNull(candidateMethod, "No candidate method supplied");
        return candidateMethod.isAnnotationPresent(this.matchOnMethodsAnnotatedWith) && candidateMethod.getParameterCount() == 1 && this.argumentCommonRootType.isAssignableFrom(candidateMethod.getParameterTypes()[0]);
    }

    @Override
    public Class<?> resolveInvocationArgumentTypeFromMethodDefinition(Method method) {
        FailFast.requireNonNull(method, "No method supplied");
        return method.getParameterTypes()[0];
    }

    @Override
    public Class<?> resolveInvocationArgumentTypeFromObject(Object argument) {
        FailFast.requireNonNull(argument, "No argument supplied");
        return argument.getClass();
    }

    @Override
    public void invokeMethod(Method methodToInvoke, Object argument, Object invokeMethodOn, Class<?> resolvedInvokeMethodWithArgumentOfType) throws Exception {
        FailFast.requireNonNull(methodToInvoke, "No methodToInvoke supplied");
        FailFast.requireNonNull(argument, "No argument supplied");
        FailFast.requireNonNull(invokeMethodOn, "No invokeMethodOn supplied");
        FailFast.requireNonNull(resolvedInvokeMethodWithArgumentOfType, "No resolvedInvokeMethodWithArgumentOfType supplied");
        methodToInvoke.invoke(invokeMethodOn, argument);
    }
}

