/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared;

import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FailFast {
    public static <T> T requireMustBeInstanceOf(Object objectThatMustBeAnInstanceOf, Class<T> mustBeAnInstanceOf) {
        return FailFast.requireMustBeInstanceOf(objectThatMustBeAnInstanceOf, mustBeAnInstanceOf, null);
    }

    public static <T> T requireMustBeInstanceOf(Object objectThatMustBeAnInstanceOf, Class<?> mustBeAnInstanceOf, String message) {
        if (objectThatMustBeAnInstanceOf == null) {
            throw new IllegalArgumentException((String)(message != null ? message : "Object was null and therefore not an instance of " + mustBeAnInstanceOf.getName()));
        }
        if (mustBeAnInstanceOf == null) {
            throw new IllegalArgumentException(message != null ? message : "Cannot verify instanceOf since the mustBeAnInstanceOf parameter is null");
        }
        if (!mustBeAnInstanceOf.isAssignableFrom(objectThatMustBeAnInstanceOf.getClass())) {
            throw new IllegalArgumentException(message != null ? message : MessageFormatter.msg("Expected {} to be an instance of {}", objectThatMustBeAnInstanceOf.getClass().getName(), mustBeAnInstanceOf.getName()));
        }
        return (T)objectThatMustBeAnInstanceOf;
    }

    public static <T> T requireNonNull(T objectThatMayNotBeNull, String message) {
        if (objectThatMayNotBeNull == null) {
            throw new IllegalArgumentException(message != null ? message : "Object was null, we expected it to be non-null");
        }
        return objectThatMayNotBeNull;
    }

    public static <T extends CharSequence> T requireNonBlank(T characterStreamThatMustNotBeEmptyOrNull, String message) {
        if (characterStreamThatMustNotBeEmptyOrNull == null) {
            throw new IllegalArgumentException(message != null ? message : "Character sequence was null, we expected it to be non-null and not empty");
        }
        if (characterStreamThatMustNotBeEmptyOrNull.length() == 0) {
            throw new IllegalArgumentException(message != null ? message : "Character sequence was empty, we expected it to be non empty");
        }
        return characterStreamThatMustNotBeEmptyOrNull;
    }

    public static <T> T requireNonNull(T objectThatMayNotBeNull, String message, Object ... messageArguments) {
        if (objectThatMayNotBeNull == null) {
            throw new IllegalArgumentException(message != null ? MessageFormatter.msg(message, messageArguments) : "Object was null, we expected it to be non-null");
        }
        return objectThatMayNotBeNull;
    }

    public static <T> T requireNonNull(T objectThatMayNotBeNull) {
        return FailFast.requireNonNull(objectThatMayNotBeNull, null);
    }

    public static void requireTrue(boolean mustBeTrue, String message) {
        FailFast.requireNonNull(message, "You must provide a NON NULL message argument to requireTrue(boolean, String)");
        if (!mustBeTrue) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void requireFalse(boolean mustBeFalse, String message) {
        FailFast.requireNonNull(message, "You must provide a NON NULL message argument to requireFalse(boolean, String)");
        if (mustBeFalse) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Object[] requireNonEmpty(Object[] items, String message) {
        if (items == null || items.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return items;
    }

    public static <T> List<T> requireNonEmpty(List<T> items, String message) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException(message);
        }
        return items;
    }

    public static <T> Set<T> requireNonEmpty(Set<T> items, String message) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException(message);
        }
        return items;
    }

    public static <K, V> Map<K, V> requireNonEmpty(Map<K, V> items, String message) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException(message);
        }
        return items;
    }
}

