/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.types;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.stream.Stream;

public abstract class GenericType<T> {
    public final Class<T> type;
    public final Type genericType;

    public GenericType() {
        Type genericSuperClass = this.getClass().getGenericSuperclass();
        if (genericSuperClass instanceof ParameterizedType) {
            this.genericType = ((ParameterizedType)genericSuperClass).getActualTypeArguments()[0];
            this.type = this.genericType instanceof Class ? (Class)this.genericType : (Class)((ParameterizedType)this.genericType).getRawType();
        } else {
            throw new IllegalStateException(MessageFormatter.msg("No generic type information available on {}", this.getClass()));
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public static Class<?> resolveGenericTypeOnSuperClass(Class<?> forType, int typeArgumentIndex) {
        FailFast.requireNonNull(forType, "No forType provided");
        Type genericSuperClass = forType.getGenericSuperclass();
        if (genericSuperClass instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)genericSuperClass).getActualTypeArguments();
            if (actualTypeArguments.length <= typeArgumentIndex) {
                throw new IllegalStateException(MessageFormatter.msg("{} only has {} type arguments, cannot resolve type argument with index {}", forType, actualTypeArguments.length, typeArgumentIndex));
            }
            Type genericType = actualTypeArguments[typeArgumentIndex];
            if (genericType instanceof Class) {
                return (Class)genericType;
            }
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        throw new IllegalStateException(MessageFormatter.msg("No generic type information available on type '{}' for typeArgument with index {}", forType.getName(), typeArgumentIndex));
    }

    public static Class<?> resolveGenericTypeForInterface(Class<?> forType, Class<?> withGenericInterface, int typeArgumentIndex) {
        ParameterizedType parameterizedGenericInterface = Stream.of(forType.getGenericInterfaces()).filter(type -> type instanceof ParameterizedType).map(ParameterizedType.class::cast).filter(type -> withGenericInterface.equals(type.getRawType()) || withGenericInterface.isAssignableFrom((Class)type.getRawType())).findFirst().orElseThrow(() -> new IllegalStateException(MessageFormatter.msg("{} doesn't implement generic Interface {} or Interface {} isn't generic/parameterized", forType, withGenericInterface.getName(), withGenericInterface.getName())));
        Type[] actualTypeArguments = parameterizedGenericInterface.getActualTypeArguments();
        if (actualTypeArguments.length <= typeArgumentIndex) {
            throw new IllegalArgumentException(MessageFormatter.msg("{} only has {} type arguments, cannot resolve type argument with index {}", forType, actualTypeArguments.length, typeArgumentIndex));
        }
        Type genericType = parameterizedGenericInterface.getActualTypeArguments()[typeArgumentIndex];
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        return (Class)((ParameterizedType)genericType).getRawType();
    }
}

