/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.messages;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.messages.MessageTemplate;
import java.util.Objects;

public abstract class AbstractMessageTemplate
implements MessageTemplate {
    protected final String key;
    protected final String defaultMessage;

    public AbstractMessageTemplate(String key, String defaultMessage) {
        this.key = FailFast.requireNonNull(key, "No key provided");
        this.defaultMessage = FailFast.requireNonNull(defaultMessage, "No defaultMessage provided");
    }

    public AbstractMessageTemplate(String key) {
        this.key = FailFast.requireNonNull(key, "No key provided");
        this.defaultMessage = null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageTemplate)) {
            return false;
        }
        MessageTemplate that = (MessageTemplate)o;
        return Objects.equals(this.key, that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return "MessageTemplate{key='" + this.key + "'}";
    }
}

