/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedExceptionRethrownException;
import java.util.function.Consumer;

@FunctionalInterface
public interface CheckedConsumer<T> {
    public static <T> Consumer<T> safe(CheckedConsumer<T> runnableThatCanFailWithACheckedException) {
        FailFast.requireNonNull(runnableThatCanFailWithACheckedException, "No CheckedConsumer instance provided");
        return t -> {
            try {
                runnableThatCanFailWithACheckedException.accept(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(e.getMessage(), e);
            }
        };
    }

    public static <T> Consumer<T> safe(String contextMessage, CheckedConsumer<T> runnableThatCanFailWithACheckedException) {
        FailFast.requireNonNull(contextMessage, "No contextMessage provided");
        FailFast.requireNonNull(runnableThatCanFailWithACheckedException, "No CheckedConsumer instance provided");
        return t -> {
            try {
                runnableThatCanFailWithACheckedException.accept(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(contextMessage, e);
            }
        };
    }

    public void accept(T var1) throws Exception;
}

