/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.collections;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.tuple.Pair;
import dk.cloudcreate.essentials.shared.functional.tuple.Tuple;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Lists {
    public static <T> Stream<Pair<Integer, T>> toIndexedStream(List<T> list) {
        FailFast.requireNonNull(list, "No list provided");
        if (list.isEmpty()) {
            return Stream.empty();
        }
        ListIterator listElementIterator = list.listIterator();
        return IntStream.range(0, list.size()).mapToObj(index -> Tuple.of(index, listElementIterator.next()));
    }

    public static <T> Optional<T> first(List<T> list) {
        FailFast.requireNonNull(list, "You must provide a non null list");
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public static <T> Optional<T> last(List<T> list) {
        FailFast.requireNonNull(list, "You must provide a non null list");
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(list.size() - 1));
    }
}

