/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.Accessibles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class Fields {
    public static Optional<Field> findField(Set<Field> fields, String fieldName, Class<?> fieldType) {
        FailFast.requireNonNull(fields, "You must supply a fields set");
        FailFast.requireNonBlank(fieldName, "You must supply a fieldName");
        FailFast.requireNonNull(fieldType, "You must supply a fieldType");
        return fields.stream().filter(field -> field.getName().equals(fieldName)).filter(field -> field.getType().equals(fieldType)).findFirst();
    }

    public static Set<Field> fields(Class<?> type) {
        FailFast.requireNonNull(type, "You must supply a type");
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> currentType = type; currentType != null; currentType = currentType.getSuperclass()) {
            for (Field declaredField : currentType.getDeclaredFields()) {
                if (currentType.getPackageName().startsWith("java.") && !Modifier.isPublic(declaredField.getModifiers()) || !fields.stream().noneMatch(field -> field.getName().equals(declaredField.getName()))) continue;
                fields.add(Accessibles.accessible(declaredField));
            }
        }
        return fields;
    }
}

