/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedExceptionRethrownException;

@FunctionalInterface
public interface CheckedRunnable {
    public static Runnable safe(CheckedRunnable runnableThatCanFailWithACheckedException) {
        FailFast.requireNonNull(runnableThatCanFailWithACheckedException, "No CheckedRunnable instance provided");
        return () -> {
            try {
                runnableThatCanFailWithACheckedException.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(e.getMessage(), e);
            }
        };
    }

    public static Runnable safe(String contextMessage, CheckedRunnable runnableThatCanFailWithACheckedException) {
        FailFast.requireNonNull(contextMessage, "No contextMessage provided");
        FailFast.requireNonNull(runnableThatCanFailWithACheckedException, "No CheckedRunnable instance provided");
        return () -> {
            try {
                runnableThatCanFailWithACheckedException.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(contextMessage, e);
            }
        };
    }

    public void run() throws Exception;
}

