/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared;

import dk.cloudcreate.essentials.shared.FailFast;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;

public final class Exceptions {
    public static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        FailFast.requireNonNull(t, "You must supply an exception");
        throw t;
    }

    public static String getStackTrace(Throwable throwable) {
        FailFast.requireNonNull(throwable, "You must specify a throwable");
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Throwable getRootCause(Throwable exception) {
        Throwable current;
        FailFast.requireNonNull(exception, "You must supply an exception");
        HashSet<Throwable> visited = new HashSet<Throwable>();
        Throwable lastValidCause = current = exception;
        while (current != null && visited.add(current)) {
            lastValidCause = current;
            current = current.getCause();
        }
        return lastValidCause;
    }

    public static boolean doesStackTraceContainExceptionOfType(Throwable exception, Class<?> exceptionType) {
        FailFast.requireNonNull(exception, "You must supply an exception");
        FailFast.requireNonNull(exceptionType, "You must supply an exception type");
        HashSet<Throwable> visited = new HashSet<Throwable>();
        for (Throwable current = exception; current != null && visited.add(current); current = current.getCause()) {
            visited.add(current);
            if (!exceptionType.isAssignableFrom(current.getClass())) continue;
            return true;
        }
        return false;
    }
}

