/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.LoadingClassFailedException;
import dk.cloudcreate.essentials.shared.reflection.ReflectionException;
import java.util.ArrayList;
import java.util.List;

public final class Classes {
    public static Class<?> forName(String fullyQualifiedClassName) throws ReflectionException {
        FailFast.requireNonNull(fullyQualifiedClassName, "You must supply a fullyQualifiedClassName");
        try {
            return Class.forName(fullyQualifiedClassName);
        }
        catch (Exception e) {
            throw new LoadingClassFailedException(MessageFormatter.msg("Failed to load class based on name '{}'", fullyQualifiedClassName), e);
        }
    }

    public static Class<?> forName(String fullyQualifiedClassName, ClassLoader classLoader) throws ReflectionException {
        FailFast.requireNonNull(fullyQualifiedClassName, "You must supply a fullyQualifiedClassName");
        FailFast.requireNonNull(classLoader, "You must supply a classLoader");
        try {
            return Class.forName(fullyQualifiedClassName, true, classLoader);
        }
        catch (Exception e) {
            throw new LoadingClassFailedException(MessageFormatter.msg("Failed to load class '{}'", fullyQualifiedClassName), e);
        }
    }

    public static int compareTypeSpecificity(Class<?> leftSide, Class<?> rightSide) {
        FailFast.requireNonNull(leftSide, "No leftSide supplied");
        FailFast.requireNonNull(rightSide, "No rightSide supplied");
        if (leftSide == rightSide) {
            return 0;
        }
        if (leftSide.isAssignableFrom(rightSide)) {
            return -1;
        }
        if (rightSide.isAssignableFrom(leftSide)) {
            return 1;
        }
        throw new IllegalArgumentException(MessageFormatter.msg("leftSide {} and rightSide {} aren't in the same type hierarchy", leftSide.getName(), rightSide.getName()));
    }

    public static List<Class<?>> superClasses(Class<?> type) {
        FailFast.requireNonNull(type, "No type supplied");
        ArrayList superClasses = new ArrayList();
        while (type != null && !type.equals(Object.class)) {
            if ((type = type.getSuperclass()) == null) continue;
            superClasses.add(type);
        }
        return superClasses;
    }

    public static boolean doesClassExistOnClasspath(String fullyQualifiedClassName) {
        try {
            Classes.forName(fullyQualifiedClassName);
            return true;
        }
        catch (LoadingClassFailedException e) {
            return false;
        }
    }

    public static boolean doesClassExistOnClasspath(String fullyQualifiedClassName, ClassLoader classLoader) {
        try {
            Classes.forName(fullyQualifiedClassName, classLoader);
            return true;
        }
        catch (LoadingClassFailedException e) {
            return false;
        }
    }
}

