/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared;

import dk.cloudcreate.essentials.shared.FailFast;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;

public final class Exceptions {
    public static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        FailFast.requireNonNull(t, "You must supply an exception");
        throw t;
    }

    public static String getStackTrace(Throwable throwable) {
        FailFast.requireNonNull(throwable, "You must specify a throwable");
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Throwable getRootCause(Throwable exception) {
        Throwable current;
        FailFast.requireNonNull(exception, "You must supply an exception");
        HashSet<Throwable> visited = new HashSet<Throwable>();
        Throwable lastValidCause = current = exception;
        while (current != null && visited.add(current)) {
            lastValidCause = current;
            current = current.getCause();
        }
        return lastValidCause;
    }

    public static boolean doesStackTraceContainExceptionOfType(Throwable exception, Class<?> exceptionType) {
        FailFast.requireNonNull(exception, "You must supply an exception");
        FailFast.requireNonNull(exceptionType, "You must supply an exception type");
        HashSet<Throwable> visited = new HashSet<Throwable>();
        for (Throwable current = exception; current != null && visited.add(current); current = current.getCause()) {
            visited.add(current);
            if (!exceptionType.isAssignableFrom(current.getClass())) continue;
            return true;
        }
        return false;
    }

    public static <T extends Throwable> void rethrowIfCriticalError(T throwable) {
        FailFast.requireNonNull(throwable, "You must supply an exception");
        if (Exceptions.isCriticalError(throwable)) {
            Exceptions.sneakyThrow(throwable);
        }
    }

    public static boolean isCriticalError(Throwable t) {
        return Exceptions.isCriticalErrorRecursive(t, new HashSet<Throwable>());
    }

    private static boolean isCriticalErrorRecursive(Throwable t, Set<Throwable> visited) {
        if (t == null || visited.contains(t)) {
            return false;
        }
        visited.add(t);
        if (t instanceof VirtualMachineError || t instanceof ThreadDeath || t instanceof LinkageError) {
            return true;
        }
        for (Throwable suppressed : t.getSuppressed()) {
            if (!Exceptions.isCriticalErrorRecursive(suppressed, visited)) continue;
            return true;
        }
        return Exceptions.isCriticalErrorRecursive(t.getCause(), visited);
    }
}

