/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional.tuple;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.tuple.Tuple;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class Either<T1, T2>
implements Tuple<Either<T1, T2>> {
    public final T1 _1;
    public final T2 _2;

    public Either(T1 t1, T2 t2) {
        if (t1 != null && t2 != null) {
            throw new IllegalArgumentException("Only one element can have a non-null value. Both t1 and t2 were non-null");
        }
        if (t1 == null && t2 == null) {
            throw new IllegalArgumentException("One element MUST have a non-null value. Both t1 and t2 were null");
        }
        this._1 = t1;
        this._2 = t2;
    }

    public static <T1, T2> Either<T1, T2> of_1(T1 t1) {
        return new Either<T1, Object>(FailFast.requireNonNull(t1, "No t1 value provided"), null);
    }

    public static <T1, T2> Either<T1, T2> of_2(T2 t2) {
        return new Either<Object, T2>(null, FailFast.requireNonNull(t2, "No t2 value provided"));
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public List<?> toList() {
        if (this._1 != null) {
            return List.of(this._1);
        }
        return List.of(this._2);
    }

    public T1 _1() {
        return this._1;
    }

    public Optional<T1> get_1() {
        return Optional.ofNullable(this._1);
    }

    public boolean is_1() {
        return this._1 != null;
    }

    public void ifIs_1(Consumer<T1> consumer) {
        FailFast.requireNonNull(consumer, "No consumer provided");
        if (this.is_1()) {
            consumer.accept(this._1);
        }
    }

    public T2 _2() {
        return this._2;
    }

    public Optional<T2> get_2() {
        return Optional.ofNullable(this._2);
    }

    public boolean is_2() {
        return this._2 != null;
    }

    public void ifIs_2(Consumer<T2> consumer) {
        FailFast.requireNonNull(consumer, "No consumer provided");
        if (this.is_2()) {
            consumer.accept(this._2);
        }
    }

    public Either<T2, T1> swap() {
        return new Either<T2, T1>(this._2, this._1);
    }

    public <R1, R2> Either<R1, R2> map(BiFunction<? super T1, ? super T2, Either<R1, R2>> mappingFunction) {
        FailFast.requireNonNull(mappingFunction, "You must supply a mapping function");
        return mappingFunction.apply(this._1, this._2);
    }

    public <R1, R2> Either<R1, R2> map(Function<? super T1, ? super R1> mappingFunction1, Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        R1 r1 = mappingFunction1.apply(this._1);
        R2 r2 = mappingFunction2.apply(this._2);
        return new Either<R1, R2>(r1, r2);
    }

    public <R1> Either<R1, T2> map1(Function<? super T1, ? super R1> mappingFunction1) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        R1 r1 = mappingFunction1.apply(this._1);
        return new Either<R1, T2>(r1, this._2);
    }

    public <R2> Either<T1, R2> map2(Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        R2 r2 = mappingFunction2.apply(this._2);
        return new Either<T1, R2>(this._1, r2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Either)) {
            return false;
        }
        Either pair = (Either)o;
        return Objects.equals(this._1, pair._1) && Objects.equals(this._2, pair._2);
    }

    public int hashCode() {
        return Objects.hash(this._1, this._2);
    }

    public String toString() {
        return "(" + String.valueOf(this._1) + ", " + String.valueOf(this._2) + ")";
    }
}

