/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional.tuple;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.TripleFunction;
import dk.cloudcreate.essentials.shared.functional.tuple.Tuple;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class Triple<T1, T2, T3>
implements Tuple<Triple<T1, T2, T3>> {
    public final T1 _1;
    public final T2 _2;
    public final T3 _3;

    public Triple(T1 t1, T2 t2, T3 t3) {
        this._1 = t1;
        this._2 = t2;
        this._3 = t3;
    }

    @Override
    public int arity() {
        return 3;
    }

    @Override
    public List<?> toList() {
        return List.of(this._1, this._2, this._3);
    }

    public T1 _1() {
        return this._1;
    }

    public T2 _2() {
        return this._2;
    }

    public T3 _3() {
        return this._3;
    }

    public <R1, R2, R3> Triple<R1, R2, R3> map(TripleFunction<? super T1, ? super T2, ? super T3, Triple<R1, R2, R3>> mappingFunction) {
        FailFast.requireNonNull(mappingFunction, "You must supply a mapping function");
        return mappingFunction.apply(this._1, this._2, this._3);
    }

    public <R1, R2, R3> Triple<R1, R2, R3> map(Function<? super T1, ? super R1> mappingFunction1, Function<? super T2, ? super R2> mappingFunction2, Function<? super T3, ? super R3> mappingFunction3) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        FailFast.requireNonNull(mappingFunction3, "You must supply a mappingFunction3");
        R1 r1 = mappingFunction1.apply(this._1);
        R2 r2 = mappingFunction2.apply(this._2);
        R3 r3 = mappingFunction3.apply(this._3);
        return Tuple.of(r1, r2, r3);
    }

    public <R1> Triple<R1, T2, T3> map1(Function<? super T1, ? super R1> mappingFunction1) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        R1 r1 = mappingFunction1.apply(this._1);
        return Tuple.of(r1, this._2, this._3);
    }

    public <R2> Triple<T1, R2, T3> map2(Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        R2 r2 = mappingFunction2.apply(this._2);
        return Tuple.of(this._1, r2, this._3);
    }

    public <R3> Triple<T1, T2, R3> map3(Function<? super T3, ? super R3> mappingFunction3) {
        FailFast.requireNonNull(mappingFunction3, "You must supply a mappingFunction3");
        R3 r3 = mappingFunction3.apply(this._3);
        return Tuple.of(this._1, this._2, r3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)o;
        return Objects.equals(this._1, triple._1) && Objects.equals(this._2, triple._2) && Objects.equals(this._3, triple._3);
    }

    public int hashCode() {
        return Objects.hash(this._1, this._2, this._3);
    }

    public String toString() {
        return "(" + String.valueOf(this._1) + ", " + String.valueOf(this._2) + ", " + String.valueOf(this._3) + ")";
    }
}

