/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional.tuple.comparable;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.tuple.comparable.ComparableTuple;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ComparablePair<T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>>
implements ComparableTuple<ComparablePair<T1, T2>> {
    public final T1 _1;
    public final T2 _2;

    public ComparablePair(T1 t1, T2 t2) {
        this._1 = t1;
        this._2 = t2;
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public List<?> toList() {
        return List.of(this._1, this._2);
    }

    public T1 _1() {
        return this._1;
    }

    public T2 _2() {
        return this._2;
    }

    public ComparablePair<T2, T1> swap() {
        return ComparableTuple.of(this._2, this._1);
    }

    public Map.Entry<T1, T2> toEntry() {
        return new AbstractMap.SimpleEntry<T1, T2>(this._1, this._2);
    }

    @Override
    public int compareTo(ComparablePair<T1, T2> o) {
        int t1Check = this._1.compareTo(o._1);
        if (t1Check != 0) {
            return t1Check;
        }
        return this._2.compareTo(o._2);
    }

    public <R1 extends Comparable<? super R1>, R2 extends Comparable<? super R2>> ComparablePair<R1, R2> map(BiFunction<? super T1, ? super T2, ComparablePair<R1, R2>> mappingFunction) {
        FailFast.requireNonNull(mappingFunction, "You must supply a mapping function");
        return mappingFunction.apply(this._1, this._2);
    }

    public <R1 extends Comparable<? super R1>, R2 extends Comparable<? super R2>> ComparablePair<R1, R2> map(Function<? super T1, ? super R1> mappingFunction1, Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        Comparable r1 = (Comparable)mappingFunction1.apply(this._1);
        Comparable r2 = (Comparable)mappingFunction2.apply(this._2);
        return ComparableTuple.of(r1, r2);
    }

    public <R1 extends Comparable<? super R1>> ComparablePair<R1, T2> map1(Function<? super T1, ? super R1> mappingFunction1) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        Comparable r1 = (Comparable)mappingFunction1.apply(this._1);
        return ComparableTuple.of(r1, this._2);
    }

    public <R2 extends Comparable<? super R2>> ComparablePair<T1, R2> map2(Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        Comparable r2 = (Comparable)mappingFunction2.apply(this._2);
        return ComparableTuple.of(this._1, r2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparablePair)) {
            return false;
        }
        ComparablePair that = (ComparablePair)o;
        return Objects.equals(this._1, that._1) && Objects.equals(this._2, that._2);
    }

    public int hashCode() {
        return Objects.hash(this._1, this._2);
    }

    public String toString() {
        return "(" + String.valueOf(this._1) + ", " + String.valueOf(this._2) + ")";
    }
}

