/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional.tuple.comparable;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.TripleFunction;
import dk.cloudcreate.essentials.shared.functional.tuple.comparable.ComparableTuple;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class ComparableTriple<T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>, T3 extends Comparable<? super T3>>
implements ComparableTuple<ComparableTriple<T1, T2, T3>> {
    public final T1 _1;
    public final T2 _2;
    public final T3 _3;

    public ComparableTriple(T1 t1, T2 t2, T3 t3) {
        this._1 = t1;
        this._2 = t2;
        this._3 = t3;
    }

    @Override
    public int arity() {
        return 3;
    }

    @Override
    public List<?> toList() {
        return List.of(this._1, this._2, this._3);
    }

    public T1 _1() {
        return this._1;
    }

    public T2 _2() {
        return this._2;
    }

    public T3 _3() {
        return this._3;
    }

    @Override
    public int compareTo(ComparableTriple<T1, T2, T3> o) {
        int t1Check = this._1.compareTo(o._1);
        if (t1Check != 0) {
            return t1Check;
        }
        int t2Check = this._2.compareTo(o._2);
        if (t2Check != 0) {
            return t2Check;
        }
        return this._3.compareTo(o._3);
    }

    public <R1 extends Comparable<? super R1>, R2 extends Comparable<? super R2>, R3 extends Comparable<? super R3>> ComparableTriple<R1, R2, R3> map(TripleFunction<? super T1, ? super T2, ? super T3, ComparableTriple<R1, R2, R3>> mappingFunction) {
        FailFast.requireNonNull(mappingFunction, "You must supply a mapping function");
        return mappingFunction.apply(this._1, this._2, this._3);
    }

    public <R1 extends Comparable<? super R1>, R2 extends Comparable<? super R2>, R3 extends Comparable<? super R3>> ComparableTriple<R1, R2, R3> map(Function<? super T1, ? super R1> mappingFunction1, Function<? super T2, ? super R2> mappingFunction2, Function<? super T3, ? super R3> mappingFunction3) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        FailFast.requireNonNull(mappingFunction3, "You must supply a mappingFunction3");
        Comparable r1 = (Comparable)mappingFunction1.apply(this._1);
        Comparable r2 = (Comparable)mappingFunction2.apply(this._2);
        Comparable r3 = (Comparable)mappingFunction3.apply(this._3);
        return ComparableTuple.of(r1, r2, r3);
    }

    public <R1 extends Comparable<? super R1>> ComparableTriple<R1, T2, T3> map1(Function<? super T1, ? super R1> mappingFunction1) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        Comparable r1 = (Comparable)mappingFunction1.apply(this._1);
        return ComparableTuple.of(r1, this._2, this._3);
    }

    public <R2 extends Comparable<? super R2>> ComparableTriple<T1, R2, T3> map2(Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        Comparable r2 = (Comparable)mappingFunction2.apply(this._2);
        return ComparableTuple.of(this._1, r2, this._3);
    }

    public <R3 extends Comparable<? super R3>> ComparableTriple<T1, T2, R3> map3(Function<? super T3, ? super R3> mappingFunction3) {
        FailFast.requireNonNull(mappingFunction3, "You must supply a mappingFunction3");
        Comparable r3 = (Comparable)mappingFunction3.apply(this._3);
        return ComparableTuple.of(this._1, this._2, r3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparableTriple)) {
            return false;
        }
        ComparableTriple that = (ComparableTriple)o;
        return Objects.equals(this._1, that._1) && Objects.equals(this._2, that._2) && Objects.equals(this._3, that._3);
    }

    public int hashCode() {
        return Objects.hash(this._1, this._2, this._3);
    }

    public String toString() {
        return "(" + String.valueOf(this._1) + ", " + String.valueOf(this._2) + ", " + String.valueOf(this._3) + ")";
    }
}

