/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.measurement;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.measurement.LogThresholds;
import dk.cloudcreate.essentials.shared.measurement.MeasurementContext;
import dk.cloudcreate.essentials.shared.measurement.MeasurementRecorder;
import java.time.Duration;
import org.slf4j.Logger;

public class LoggingMeasurementRecorder
implements MeasurementRecorder {
    private final Logger logger;
    private final LogThresholds thresholds;

    public LoggingMeasurementRecorder(Logger logger, LogThresholds thresholds) {
        this.logger = FailFast.requireNonNull(logger, "No logger provided");
        this.thresholds = FailFast.requireNonNull(thresholds, "No thresholds provided");
    }

    @Override
    public void record(MeasurementContext context, Duration duration) {
        FailFast.requireNonNull(context, "No context provided");
        FailFast.requireNonNull(duration, "No duration provided");
        long millis = duration.toMillis();
        String logMessage = String.format("Measurement [%s]: %d ms. Tags: %s: %s", context.getMetricName(), millis, context.getTags(), context.getDescription());
        if (millis >= this.thresholds.getError()) {
            this.logger.error(logMessage);
        } else if (millis >= this.thresholds.getWarn()) {
            this.logger.warn(logMessage);
        } else if (millis >= this.thresholds.getInfo()) {
            this.logger.info(logMessage);
        } else if (millis >= this.thresholds.getDebug()) {
            this.logger.debug(logMessage);
        } else {
            this.logger.trace(logMessage);
        }
    }
}

