/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.measurement;

import dk.cloudcreate.essentials.shared.FailFast;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MeasurementContext {
    private final String metricName;
    private final String description;
    private final Map<String, String> tags;

    private MeasurementContext(Builder builder) {
        this.metricName = builder.metricName;
        this.description = builder.description;
        this.tags = Collections.unmodifiableMap(new HashMap<String, String>(builder.tags));
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public static Builder builder(String metricName) {
        return new Builder(metricName);
    }

    public static class Builder {
        private final String metricName;
        private String description = "";
        private final Map<String, String> tags = new HashMap<String, String>();

        public Builder(String metricName) {
            this.metricName = FailFast.requireNonNull(metricName, "No metricName provided");
        }

        public Builder description(String description) {
            this.description = FailFast.requireNonNull(description, "No description provided");
            return this;
        }

        public Builder tag(String key, CharSequence value) {
            this.tags.put(FailFast.requireNonNull(key, "No key provided"), FailFast.requireNonNull(value, "No value provided").toString());
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags.put(FailFast.requireNonNull(key, "No key provided"), FailFast.requireNonNull(value, "No value provided"));
            return this;
        }

        public Builder optionalTag(String key, String value) {
            if (value != null) {
                this.tags.put(FailFast.requireNonNull(key, "No key provided"), value);
            }
            return this;
        }

        public Builder tag(String key, int value) {
            this.tags.put(FailFast.requireNonNull(key, "No key provided"), Integer.toString(value));
            return this;
        }

        public MeasurementContext build() {
            return new MeasurementContext(this);
        }
    }
}

