/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.measurement;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.measurement.MeasurementContext;
import dk.cloudcreate.essentials.shared.measurement.MeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MicrometerMeasurementRecorder;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class MeasurementTaker {
    private final List<MeasurementRecorder> recorders;

    private MeasurementTaker(List<MeasurementRecorder> recorders) {
        FailFast.requireNonNull(recorders, "No recorders provided");
        this.recorders = Collections.unmodifiableList(recorders);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T record(MeasurementContext context, Supplier<T> block) {
        FailFast.requireNonNull(context, "No context provided");
        FailFast.requireNonNull(block, "No block provided");
        long start = System.nanoTime();
        try {
            T t = block.get();
            return t;
        }
        finally {
            Duration elapsed = Duration.ofNanos(System.nanoTime() - start);
            this.recorders.forEach(recorder -> recorder.record(context, elapsed));
        }
    }

    public void recordTime(MeasurementContext context, Duration elapsed) {
        FailFast.requireNonNull(context, "No context provided");
        FailFast.requireNonNull(elapsed, "No elapsed provided");
        this.recorders.forEach(recorder -> recorder.record(context, elapsed));
    }

    public FluentMeasurementContext context(String metricName) {
        return new FluentMeasurementContext(this, metricName);
    }

    public static class Builder {
        private final List<MeasurementRecorder> recorders = new ArrayList<MeasurementRecorder>();

        public Builder addRecorder(MeasurementRecorder recorder) {
            this.recorders.add(FailFast.requireNonNull(recorder, "No recorder provided"));
            return this;
        }

        public Builder withOptionalMicrometerMeasurementRecorder(Optional<MeterRegistry> meterRegistryOptional) {
            FailFast.requireNonNull(meterRegistryOptional, "No meterRegistryOptional provided");
            meterRegistryOptional.ifPresent(registry -> this.addRecorder(new MicrometerMeasurementRecorder((MeterRegistry)registry)));
            return this;
        }

        public MeasurementTaker build() {
            return new MeasurementTaker(this.recorders);
        }
    }

    public static class FluentMeasurementContext {
        private final MeasurementTaker measurementTaker;
        private final MeasurementContext.Builder contextBuilder;

        private FluentMeasurementContext(MeasurementTaker measurementTaker, String metricName) {
            this.measurementTaker = FailFast.requireNonNull(measurementTaker, "No measurementTaker provided");
            this.contextBuilder = MeasurementContext.builder(metricName);
        }

        public FluentMeasurementContext description(String description) {
            this.contextBuilder.description(description);
            return this;
        }

        public FluentMeasurementContext tag(String key, CharSequence value) {
            this.contextBuilder.tag(key, value);
            return this;
        }

        public FluentMeasurementContext tag(String key, String value) {
            this.contextBuilder.tag(key, value);
            return this;
        }

        public FluentMeasurementContext tag(String key, int value) {
            this.contextBuilder.tag(key, value);
            return this;
        }

        public <T> T record(Supplier<T> block) {
            FailFast.requireNonNull(block, "No block provided");
            return this.measurementTaker.record(this.contextBuilder.build(), block);
        }

        public FluentMeasurementContext optionalTag(String key, String value) {
            this.contextBuilder.optionalTag(key, value);
            return this;
        }
    }
}

