/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.measurement;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.measurement.MeasurementContext;
import dk.cloudcreate.essentials.shared.measurement.MeasurementRecorder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.stream.Stream;

public class MicrometerMeasurementRecorder
implements MeasurementRecorder {
    private final MeterRegistry meterRegistry;

    public MicrometerMeasurementRecorder(MeterRegistry meterRegistry) {
        this.meterRegistry = FailFast.requireNonNull(meterRegistry, "No meterRegistry provided");
    }

    @Override
    public void record(MeasurementContext context, Duration duration) {
        FailFast.requireNonNull(context, "No context provided");
        FailFast.requireNonNull(duration, "No duration provided");
        String[] tagArray = (String[])context.getTags().entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).toArray(String[]::new);
        Timer.builder((String)context.getMetricName()).description(context.getDescription()).tags(tagArray).publishPercentileHistogram().publishPercentiles(new double[]{0.95, 0.99}).register(this.meterRegistry).record(duration);
    }
}

