/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection;

import dk.cloudcreate.essentials.shared.FailFast;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionalInterfaceLoggingNameResolver {
    private static final Logger logger = LoggerFactory.getLogger(FunctionalInterfaceLoggingNameResolver.class);
    private static final ConcurrentMap<Class<?>, String> loggingNameCache = new ConcurrentHashMap();

    private FunctionalInterfaceLoggingNameResolver() {
    }

    public static String resolveLoggingName(Object handler) {
        FailFast.requireNonNull(handler, "No handler provided");
        Class<?> clazz = handler.getClass();
        return loggingNameCache.computeIfAbsent(clazz, clz -> FunctionalInterfaceLoggingNameResolver.computeLoggingName(handler));
    }

    private static String computeLoggingName(Object handler) {
        Class<?> clazz = handler.getClass();
        if (clazz.isSynthetic() || clazz.getName().contains("$$Lambda$")) {
            Map.Entry<String, Method> functionalInfo = FunctionalInterfaceLoggingNameResolver.getFunctionalInterfaceAndMethod(clazz);
            if (functionalInfo != null) {
                return FunctionalInterfaceLoggingNameResolver.extractClassNameFromLambda(clazz.getSimpleName()) + "::" + functionalInfo.getKey();
            }
            String stackTraceInfo = FunctionalInterfaceLoggingNameResolver.extractFromStackTrace();
            return Objects.requireNonNullElseGet(stackTraceInfo, clazz::getSimpleName);
        }
        if (clazz.isAnonymousClass()) {
            Class<?> enclosingClass = clazz.getEnclosingClass();
            String enclosingName = enclosingClass != null ? enclosingClass.getSimpleName() : "";
            Method[] methods = clazz.getDeclaredMethods();
            Method functionalMethod = Arrays.stream(methods).filter(m -> !m.isBridge() && !m.isSynthetic()).findFirst().orElse(null);
            String methodName = functionalMethod != null ? functionalMethod.getName() : "";
            return enclosingName + "$Anonymous" + (String)(methodName.isEmpty() ? "" : "::" + methodName);
        }
        return clazz.getSimpleName();
    }

    public static String extractClassNameFromLambda(String lambdaString) {
        if (!lambdaString.contains("$$Lambda$")) {
            return lambdaString;
        }
        int lambdaIndex = lambdaString.indexOf("$$Lambda$");
        return lambdaString.substring(0, lambdaIndex);
    }

    private static Map.Entry<String, Method> getFunctionalInterfaceAndMethod(Class<?> lambdaClass) {
        try {
            for (Class<?> _interface : lambdaClass.getInterfaces()) {
                Method[] methods = _interface.getMethods();
                Method functionalMethod = Arrays.stream(methods).filter(m -> !m.isDefault() && !Modifier.isStatic(m.getModifiers())).findFirst().orElse(null);
                if (functionalMethod == null) continue;
                return Map.entry(_interface.getSimpleName(), functionalMethod);
            }
        }
        catch (SecurityException e) {
            logger.debug("Security exception when extracting functional interface info", (Throwable)e);
        }
        catch (Exception e) {
            logger.debug("Exception when extracting functional interface info", (Throwable)e);
        }
        return null;
    }

    private static String extractFromStackTrace() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 3; i < Math.min(stackTrace.length, 10); ++i) {
                StackTraceElement element = stackTrace[i];
                String className = element.getClassName();
                if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.equals(FunctionalInterfaceLoggingNameResolver.class.getName())) continue;
                String simpleClassName = className;
                if (className.lastIndexOf(46) > 0) {
                    simpleClassName = className.substring(className.lastIndexOf(46) + 1);
                }
                return simpleClassName + "::" + element.getMethodName() + ":" + element.getLineNumber();
            }
        }
        catch (SecurityException e) {
            logger.debug("Security exception when extracting stack trace info", (Throwable)e);
        }
        catch (Exception e) {
            logger.debug("Exception when extracting stack trace info", (Throwable)e);
        }
        return null;
    }
}

