/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection.invocation;

import dk.cloudcreate.essentials.shared.measurement.LogThresholds;
import dk.cloudcreate.essentials.shared.measurement.LoggingMeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MeasurementContext;
import dk.cloudcreate.essentials.shared.measurement.MeasurementTaker;
import dk.cloudcreate.essentials.shared.reflection.FunctionalInterfaceLoggingNameResolver;
import dk.cloudcreate.essentials.shared.reflection.invocation.LoggerAwareInvocationTracker;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class MeasurementInvocationTracker
implements LoggerAwareInvocationTracker {
    private Logger logger;
    private MeasurementTaker measurementTaker;
    private static final ConcurrentHashMap<Method, String> loggingNameCache = new ConcurrentHashMap();

    @Override
    public void trackMethodInvoked(Method method, Object invokeMethodsOn, Duration duration, Object argument) {
        if (this.logger != null) {
            this.measurementTaker = MeasurementTaker.builder().addRecorder(new LoggingMeasurementRecorder(this.logger, this.getLogThresholds())).build();
        }
        if (this.measurementTaker != null) {
            String methodLoggingName = loggingNameCache.computeIfAbsent(method, MeasurementInvocationTracker::getMethodDescription);
            this.measurementTaker.recordTime(MeasurementContext.builder("essentials.invocation").description("Time it takes to invoke a method").tag("class", FunctionalInterfaceLoggingNameResolver.resolveLoggingName(invokeMethodsOn)).tag("method", methodLoggingName).build(), duration);
        }
    }

    protected LogThresholds getLogThresholds() {
        return LogThresholds.defaultThresholds();
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private static String getMethodDescription(Method method) {
        return method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
    }
}

