/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection.invocation;

import dk.cloudcreate.essentials.shared.Exceptions;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.functional.CheckedExceptionRethrownException;
import dk.cloudcreate.essentials.shared.functional.CheckedRunnable;
import dk.cloudcreate.essentials.shared.reflection.Classes;
import dk.cloudcreate.essentials.shared.reflection.Methods;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationException;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationStrategy;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationTracker;
import dk.cloudcreate.essentials.shared.reflection.invocation.LoggerAwareInvocationTracker;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.reflection.invocation.NoMatchingMethodsHandler;
import dk.cloudcreate.essentials.shared.time.StopWatch;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PatternMatchingMethodInvoker<ARGUMENT_COMMON_ROOT_TYPE> {
    private final Logger log;
    private final MethodPatternMatcher<ARGUMENT_COMMON_ROOT_TYPE> methodPatternMatcher;
    private final InvocationStrategy invocationStrategy;
    private final NoMatchingMethodsHandler defaultNoMatchingMethodsHandler;
    private final InvocationTracker invocationTracker;
    private final Object invokeMethodsOn;
    private Map<Class<?>, Method> invokableMethods;
    private final ConcurrentMap<Class<?>, Class<?>> invokeMostSpecificTypeMatchCache = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Set<Class<?>>> invokeAllMatchesCache = new ConcurrentHashMap();

    public PatternMatchingMethodInvoker(Object invokeMethodsOn, MethodPatternMatcher<ARGUMENT_COMMON_ROOT_TYPE> methodPatternMatcher, InvocationStrategy invocationStrategy) {
        this(invokeMethodsOn, methodPatternMatcher, invocationStrategy, Optional.empty(), Optional.empty());
    }

    public PatternMatchingMethodInvoker(Object invokeMethodsOn, MethodPatternMatcher<ARGUMENT_COMMON_ROOT_TYPE> methodPatternMatcher, InvocationStrategy invocationStrategy, Optional<NoMatchingMethodsHandler> defaultNoMatchingMethodsHandler, Optional<InvocationTracker> invocationTracker) {
        FailFast.requireNonNull(defaultNoMatchingMethodsHandler, "No defaultNoMatchingMethodsHandler instance provided");
        this.invokeMethodsOn = FailFast.requireNonNull(invokeMethodsOn, "You must provide an object where methods will be invoked on - aka invokeMethodsOn");
        this.methodPatternMatcher = FailFast.requireNonNull(methodPatternMatcher, "You must provide a methodPatternMatcher");
        this.invocationStrategy = FailFast.requireNonNull(invocationStrategy, "You must provide an invocationStrategy");
        this.defaultNoMatchingMethodsHandler = defaultNoMatchingMethodsHandler.orElseGet(() -> argument -> {});
        this.invocationTracker = invocationTracker.orElse(new InvocationTracker.NoOpInvocationTracker());
        this.log = LoggerFactory.getLogger(invokeMethodsOn.getClass());
        this.resolveInvokableMethods();
        InvocationTracker invocationTracker2 = this.invocationTracker;
        if (invocationTracker2 instanceof LoggerAwareInvocationTracker) {
            LoggerAwareInvocationTracker i = (LoggerAwareInvocationTracker)invocationTracker2;
            i.setLogger(this.log);
        }
    }

    private void resolveInvokableMethods() {
        Class<?> onClass = this.invokeMethodsOn.getClass();
        this.invokableMethods = Methods.methods(onClass).stream().filter(method -> method.getDeclaringClass() != Object.class).filter(this.methodPatternMatcher::isInvokableMethod).collect(Collectors.toMap(this.methodPatternMatcher::resolveInvocationArgumentTypeFromMethodDefinition, Function.identity()));
        if (this.log.isTraceEnabled()) {
            this.log.trace("Invokable Methods on '{}' using method pattern-matcher: {}", onClass, (Object)this.methodPatternMatcher.getClass().getName());
            this.log.trace("--------------------------------------------------------------------------------------------------");
            this.invokableMethods.forEach((invokeWithType, method) -> this.log.trace("Argument of type '{}' can invoke method: {}", (Object)invokeWithType.getName(), (Object)method.toGenericString()));
        }
    }

    public void invoke(Object argument) {
        this.invoke(argument, this.defaultNoMatchingMethodsHandler);
    }

    public void invoke(Object argument, NoMatchingMethodsHandler noMatchingMethodsHandler) {
        FailFast.requireNonNull(argument, "No argument supplied");
        FailFast.requireNonNull(noMatchingMethodsHandler, "No noMatchingMethodsHandler supplied");
        Class<?> resolvedInvokeMethodWithArgumentOfType = this.methodPatternMatcher.resolveInvocationArgumentTypeFromObject(argument);
        if (resolvedInvokeMethodWithArgumentOfType == null) {
            throw new InvocationException(MessageFormatter.msg("Didn't methodPatternMatcher.resolveInvocationArgumentTypeFromArgumentInstance returned null for argument with type '{}'", argument.getClass()));
        }
        switch (this.invocationStrategy) {
            case InvokeMostSpecificTypeMatched: {
                this.invokeMostSpecificTypeMatched(argument, resolvedInvokeMethodWithArgumentOfType, noMatchingMethodsHandler);
                break;
            }
            case InvokeAllMatches: {
                this.invokeAllMatches(argument, resolvedInvokeMethodWithArgumentOfType, noMatchingMethodsHandler);
                break;
            }
            default: {
                throw new IllegalStateException(MessageFormatter.msg("Unsupported invocationStrategy '{}'", new Object[]{this.invocationStrategy}));
            }
        }
    }

    private void invokeAllMatches(Object argument, Class<?> resolvedInvokeMethodWithArgumentOfType, NoMatchingMethodsHandler noMatchingMethodsHandler) {
        FailFast.requireNonNull(argument, "argument may not be NULL");
        FailFast.requireNonNull(resolvedInvokeMethodWithArgumentOfType, "resolvedInvokeMethodWithArgumentOfType may not be NULL");
        FailFast.requireNonNull(noMatchingMethodsHandler, "noMatchingMethodsHandler may not be NULL");
        Set allMatchingArgumentTypes = this.invokeAllMatchesCache.computeIfAbsent(resolvedInvokeMethodWithArgumentOfType, _ignore_ -> this.invokableMethods.keySet().stream().filter(argumentType -> argumentType.isAssignableFrom(resolvedInvokeMethodWithArgumentOfType)).collect(Collectors.toSet()));
        String contextDescription = MessageFormatter.msg("resolvedInvokeMethodWithArgumentOfType: '{}' and argument-type: '{}'", resolvedInvokeMethodWithArgumentOfType.getName(), argument.getClass().getName());
        if (allMatchingArgumentTypes.isEmpty()) {
            this.log.trace("invokeAllMatches: Didn't find any matching methods for {}, calling the noMatchingMethodsHandler", (Object)contextDescription);
            noMatchingMethodsHandler.noMatchesFor(argument);
        } else {
            this.log.trace("invokeAllMatches: Found {} matching methods for {}", (Object)allMatchingArgumentTypes.size(), (Object)contextDescription);
            allMatchingArgumentTypes.forEach(methodInvokableType -> {
                Method methodToInvoke = this.invokableMethods.get(methodInvokableType);
                if (methodToInvoke == null) {
                    throw new IllegalStateException(MessageFormatter.msg("Expected to find a Method in invokableMethods that matched resolved invokableMethodType: '{}' based on {}", methodInvokableType.getName(), contextDescription));
                }
                this.log.trace("invokeAllMatches: Invoking method {} based on {}", (Object)methodToInvoke.toGenericString(), (Object)contextDescription);
                this.invoke(methodToInvoke, argument, resolvedInvokeMethodWithArgumentOfType);
            });
        }
    }

    private void invokeMostSpecificTypeMatched(Object argument, Class<?> resolvedInvokeMethodWithArgumentOfType, NoMatchingMethodsHandler noMatchingMethodsHandler) {
        FailFast.requireNonNull(argument, "argument may not be NULL");
        FailFast.requireNonNull(resolvedInvokeMethodWithArgumentOfType, "resolvedInvokeMethodWithArgumentOfType may not be NULL");
        FailFast.requireNonNull(noMatchingMethodsHandler, "noMatchingMethodsHandler may not be NULL");
        Class<?> mostSpecificMatchingArgumentType = this.findMostSpecificMatchingArgumentType(resolvedInvokeMethodWithArgumentOfType);
        String contextDescription = MessageFormatter.msg("resolvedInvokeMethodWithArgumentOfType: '{}' and argument-type: '{}'", resolvedInvokeMethodWithArgumentOfType.getName(), argument.getClass().getName());
        if (mostSpecificMatchingArgumentType != null) {
            Method methodToInvoke = this.invokableMethods.get(mostSpecificMatchingArgumentType);
            if (methodToInvoke == null) {
                throw new InvocationException(MessageFormatter.msg("Expected to find a Method that matched resolved mostSpecificMatchingArgumentType: '{}' based on {}", mostSpecificMatchingArgumentType.getName(), contextDescription));
            }
            this.log.trace("invokeMostSpecificTypeMatched: Resolved mostSpecificMatchingArgumentType '{}' and methodToInvoke: {} based on {}", new Object[]{mostSpecificMatchingArgumentType.getName(), methodToInvoke.toGenericString(), contextDescription});
            this.invoke(methodToInvoke, argument, resolvedInvokeMethodWithArgumentOfType);
        } else {
            this.log.trace("invokeMostSpecificTypeMatched: Didn't find a matching method for {}, calling the noMatchingMethodsHandler", (Object)contextDescription);
            noMatchingMethodsHandler.noMatchesFor(argument);
        }
    }

    private Class<?> findMostSpecificMatchingArgumentType(Class<?> concreteArgumentType) {
        Class mostSpecificMatchingArgumentType = this.invokeMostSpecificTypeMatchCache.computeIfAbsent(concreteArgumentType, _ignore_ -> this.invokableMethods.keySet().stream().filter(cls -> cls.isAssignableFrom(concreteArgumentType)).max(Classes::compareTypeSpecificity).orElse(Void.class));
        if (mostSpecificMatchingArgumentType != Void.class) {
            return mostSpecificMatchingArgumentType;
        }
        return null;
    }

    private void invoke(Method methodToInvoke, Object argument, Class<?> resolvedInvokeMethodWithArgumentOfType) {
        FailFast.requireNonNull(methodToInvoke, "No methodToInvoke supplied");
        FailFast.requireNonNull(argument, "No argument supplied");
        String contextDescription = MessageFormatter.msg("method '{}' argument '{}' on '{}'", methodToInvoke.toGenericString(), argument, this.invokeMethodsOn);
        try {
            this.log.trace("Invoking {}", (Object)contextDescription);
            Duration duration = StopWatch.time(CheckedRunnable.safe(() -> this.methodPatternMatcher.invokeMethod(methodToInvoke, argument, this.invokeMethodsOn, resolvedInvokeMethodWithArgumentOfType)));
            this.invocationTracker.trackMethodInvoked(methodToInvoke, this.invokeMethodsOn, duration, argument);
            this.log.trace("Took {} ms to invoke {}", (Object)duration.toMillis(), (Object)contextDescription);
        }
        catch (CheckedExceptionRethrownException e) {
            this.log.debug(MessageFormatter.msg("Failed to invoke {}", contextDescription), e.getCause());
            Exceptions.sneakyThrow(e.getCause());
        }
        catch (RuntimeException e) {
            this.log.debug(MessageFormatter.msg("Failed to invoke {}", contextDescription), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.log.debug(MessageFormatter.msg("Failed to invoke {}", contextDescription), e);
            Exceptions.sneakyThrow(e);
        }
    }

    public boolean hasMatchingMethod(Class<?> argumentType) {
        FailFast.requireNonNull(argumentType, "No argumentType provided");
        return this.findMostSpecificMatchingArgumentType(argumentType) != null;
    }
}

