/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedExceptionRethrownException;
import dk.cloudcreate.essentials.shared.functional.TripleFunction;

@FunctionalInterface
public interface CheckedTripleFunction<T1, T2, T3, R> {
    public static <T1, T2, T3, R> TripleFunction<T1, T2, T3, R> safe(CheckedTripleFunction<T1, T2, T3, R> functionThatCanFailWithACheckedException) {
        FailFast.requireNonNull(functionThatCanFailWithACheckedException, "No CheckedTripleFunction instance provided");
        return (t1, t2, t3) -> {
            try {
                return functionThatCanFailWithACheckedException.apply(t1, t2, t3);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(e.getMessage(), e);
            }
        };
    }

    public static <T1, T2, T3, R> TripleFunction<T1, T2, T3, R> safe(String contextMessage, CheckedTripleFunction<T1, T2, T3, R> functionThatCanFailWithACheckedException) {
        FailFast.requireNonNull(contextMessage, "No contextMessage provided");
        FailFast.requireNonNull(functionThatCanFailWithACheckedException, "No CheckedTripleFunction instance provided");
        return (t1, t2, t3) -> {
            try {
                return functionThatCanFailWithACheckedException.apply(t1, t2, t3);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(contextMessage, e);
            }
        };
    }

    public R apply(T1 var1, T2 var2, T3 var3) throws Exception;
}

