/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.time;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.time.Timing;
import dk.cloudcreate.essentials.shared.time.TimingWithResult;
import java.time.Duration;
import java.util.function.Supplier;

public final class StopWatch {
    private final String description;
    private final long start;

    public static StopWatch start(String description) {
        return new StopWatch(description);
    }

    public static StopWatch start() {
        return new StopWatch();
    }

    public StopWatch() {
        this(null);
    }

    public StopWatch(String description) {
        this.description = description;
        this.start = System.nanoTime();
    }

    public Timing stop() {
        return Timing.of(this.description, Duration.ofNanos(System.nanoTime() - this.start));
    }

    public static Duration time(Runnable operation) {
        FailFast.requireNonNull(operation, "You must supply an operation to time");
        long start = System.nanoTime();
        operation.run();
        long finish = System.nanoTime();
        return Duration.ofNanos(finish - start);
    }

    public static <R> TimingWithResult<R> time(Supplier<R> operation) {
        FailFast.requireNonNull(operation, "You must supply an operation to time");
        long start = System.nanoTime();
        R result = operation.get();
        long finish = System.nanoTime();
        return TimingWithResult.of(result, Duration.ofNanos(finish - start));
    }
}

