/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional.tuple;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.tuple.Empty;
import dk.cloudcreate.essentials.shared.functional.tuple.Pair;
import dk.cloudcreate.essentials.shared.functional.tuple.Single;
import dk.cloudcreate.essentials.shared.functional.tuple.Triple;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public interface Tuple<CONCRETE_TUPLE extends Tuple<CONCRETE_TUPLE>>
extends Serializable {
    public int arity();

    public List<?> toList();

    public static Empty empty() {
        return Empty.instance();
    }

    public static Empty of() {
        return Empty.instance();
    }

    public static <T1> Single<T1> of(T1 t1) {
        return new Single<T1>(t1);
    }

    public static <T1, T2> Pair<T1, T2> of(T1 t1, T2 t2) {
        return new Pair<T1, T2>(t1, t2);
    }

    public static <T1, T2> Pair<T1, T2> fromEntry(Map.Entry<? extends T1, ? extends T2> entry) {
        FailFast.requireNonNull(entry, "You must supply an entry value");
        return new Pair<T1, T2>(entry.getKey(), entry.getValue());
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> of(T1 t1, T2 t2, T3 t3) {
        return new Triple<T1, T2, T3>(t1, t2, t3);
    }
}

