/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.interceptor;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.interceptor.Interceptor;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorChain;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorOrder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultInterceptorChain<OPERATION, RESULT, INTERCEPTOR_TYPE extends Interceptor>
implements InterceptorChain<OPERATION, RESULT, INTERCEPTOR_TYPE> {
    private static final Logger log = LoggerFactory.getLogger(DefaultInterceptorChain.class);
    private final OPERATION operation;
    private final Iterator<INTERCEPTOR_TYPE> interceptorIterator;
    private final BiFunction<INTERCEPTOR_TYPE, InterceptorChain<OPERATION, RESULT, INTERCEPTOR_TYPE>, RESULT> interceptorMethodInvoker;
    private final Supplier<RESULT> defaultBehaviour;

    public DefaultInterceptorChain(OPERATION operation, List<INTERCEPTOR_TYPE> interceptors, BiFunction<INTERCEPTOR_TYPE, InterceptorChain<OPERATION, RESULT, INTERCEPTOR_TYPE>, RESULT> interceptorMethodInvoker, Supplier<RESULT> defaultBehaviour) {
        this.operation = FailFast.requireNonNull(operation, "No operation provided");
        this.interceptorIterator = FailFast.requireNonNull(interceptors, "No interceptors provided").iterator();
        this.interceptorMethodInvoker = FailFast.requireNonNull(interceptorMethodInvoker, "No interceptorMethodInvoker provided");
        this.defaultBehaviour = FailFast.requireNonNull(defaultBehaviour, "No defaultBehaviour supplier provided");
    }

    public static <INTERCEPTOR_TYPE> List<INTERCEPTOR_TYPE> sortInterceptorsByOrder(List<INTERCEPTOR_TYPE> interceptors) {
        interceptors.sort(Comparator.comparingInt(interceptor -> interceptor.getClass().getAnnotation(InterceptorOrder.class) != null ? interceptor.getClass().getAnnotation(InterceptorOrder.class).value() : 10));
        return interceptors;
    }

    @Override
    public RESULT proceed() {
        if (this.interceptorIterator.hasNext()) {
            Interceptor interceptor = (Interceptor)this.interceptorIterator.next();
            log.trace("Invoking interceptor '{}'", (Object)interceptor.getClass().getName());
            return this.interceptorMethodInvoker.apply(interceptor, this);
        }
        log.trace("Invoking default behaviour for operation '{}'", (Object)this.operation.getClass().getSimpleName());
        return this.defaultBehaviour.get();
    }

    @Override
    public OPERATION operation() {
        return this.operation;
    }

    public String toString() {
        return "InterceptorChain{operation=" + this.operation + "}";
    }
}

