/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;

public final class BoxedTypes {
    public static boolean isPrimitiveType(Class<?> type) {
        FailFast.requireNonNull(type, "You must supply a type");
        return type.isPrimitive();
    }

    public static boolean isBoxedType(Class<?> type) {
        FailFast.requireNonNull(type, "You must supply a type");
        return Boolean.class == type || Integer.class == type || Long.class == type || Short.class == type || Byte.class == type || Double.class == type || Float.class == type || Character.class == type || Void.class == type;
    }

    public static Class<?> boxedType(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (!type.isPrimitive()) {
            return type;
        }
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        if (Void.TYPE == type) {
            return Void.class;
        }
        throw new RuntimeException(MessageFormatter.msg("Unsupported boxed type '{}'", type.getName()));
    }
}

