/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.BoxedTypes;
import java.util.Arrays;

public final class Parameters {
    public static boolean parameterTypesMatches(Class<?>[] actualParameterTypes, Class<?>[] declaredParameterTypes, boolean exactMatch) {
        FailFast.requireNonNull(actualParameterTypes, "No actualParameterTypes supplied");
        FailFast.requireNonNull(declaredParameterTypes, "No declaredParameterTypes supplied");
        if (actualParameterTypes.length != declaredParameterTypes.length) {
            return false;
        }
        if (exactMatch) {
            return Arrays.deepEquals(actualParameterTypes, declaredParameterTypes);
        }
        for (int index = 0; index < actualParameterTypes.length; ++index) {
            Class<?> declaredParameterType;
            Class<?> actualParameterType = BoxedTypes.boxedType(actualParameterTypes[index]);
            if (actualParameterType == NULL_ARGUMENT_TYPE.class || (declaredParameterType = BoxedTypes.boxedType(declaredParameterTypes[index])).isAssignableFrom(actualParameterType)) continue;
            return false;
        }
        return true;
    }

    public static Class<?>[] argumentTypes(Object ... arguments) {
        if (arguments == null) {
            return new Class[0];
        }
        Class[] parameterTypes = new Class[arguments.length];
        for (int index = 0; index < arguments.length; ++index) {
            parameterTypes[index] = arguments[index] != null ? arguments[index].getClass() : NULL_ARGUMENT_TYPE.class;
        }
        return parameterTypes;
    }

    public static final class NULL_ARGUMENT_TYPE {
    }
}

