/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.concurrent;

import dk.cloudcreate.essentials.shared.FailFast;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadFactoryBuilder {
    private String nameFormat;
    private Optional<ThreadFactory> delegateThreadFactory = Optional.empty();
    private Integer priority;
    private boolean daemon;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static ThreadFactoryBuilder builder() {
        return new ThreadFactoryBuilder();
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.buildThreadFactory(this);
    }

    private static ThreadFactory buildThreadFactory(ThreadFactoryBuilder threadFactoryBuilder) {
        String nameFormat = threadFactoryBuilder.nameFormat;
        boolean daemon = threadFactoryBuilder.daemon;
        Integer priority = threadFactoryBuilder.priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = threadFactoryBuilder.uncaughtExceptionHandler;
        ThreadFactory actualThreadFactory = threadFactoryBuilder.delegateThreadFactory.orElse(Executors.defaultThreadFactory());
        AtomicLong threadCounter = new AtomicLong();
        return r -> {
            Thread newThread = actualThreadFactory.newThread(r);
            newThread.setName(String.format(nameFormat, threadCounter.incrementAndGet()));
            newThread.setDaemon(daemon);
            if (priority != null) {
                newThread.setPriority(priority);
            }
            if (uncaughtExceptionHandler != null) {
                newThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
            return newThread;
        };
    }

    public ThreadFactoryBuilder nameFormat(String nameFormat) {
        this.nameFormat = FailFast.requireNonNull(nameFormat, "No nameFormat was provided");
        return this;
    }

    public ThreadFactoryBuilder delegateThreadFactory(ThreadFactory delegateThreadFactory) {
        this.delegateThreadFactory = Optional.ofNullable(delegateThreadFactory);
        return this;
    }

    public ThreadFactoryBuilder priority(int priority) {
        FailFast.requireTrue(priority >= 1, "priority must be equal or larger to 1");
        FailFast.requireTrue(priority <= 10, "priority must be equal or less to 10");
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }
}

