/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.time;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.time.TimingResult;
import java.time.Duration;
import java.util.function.Supplier;

public class StopWatch {
    public static Duration time(Runnable operation) {
        FailFast.requireNonNull(operation, "You must supply an operation to time");
        long start = System.nanoTime();
        operation.run();
        long finish = System.nanoTime();
        return Duration.ofNanos(finish - start);
    }

    public static <R> TimingResult<R> time(Supplier<R> operation) {
        FailFast.requireNonNull(operation, "You must supply an operation to time");
        long start = System.nanoTime();
        R result = operation.get();
        long finish = System.nanoTime();
        return TimingResult.of(result, Duration.ofNanos(finish - start));
    }
}

