/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.types;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public abstract class GenericType<T> {
    public final Class<T> type;
    public final Type genericType;

    public GenericType() {
        Type genericSuperClass = this.getClass().getGenericSuperclass();
        if (genericSuperClass instanceof ParameterizedType) {
            this.genericType = ((ParameterizedType)genericSuperClass).getActualTypeArguments()[0];
            this.type = this.genericType instanceof Class ? (Class)this.genericType : (Class)((ParameterizedType)this.genericType).getRawType();
        } else {
            throw new IllegalStateException("No generic type information available");
        }
    }

    public static Optional<Class<?>> resolveGenericType(Class<?> forType, int typeArgumentIndex) {
        FailFast.requireNonNull(forType, "No forType provided");
        Type genericSuperClass = forType.getGenericSuperclass();
        if (genericSuperClass instanceof ParameterizedType) {
            Type genericType = ((ParameterizedType)genericSuperClass).getActualTypeArguments()[typeArgumentIndex];
            if (genericType instanceof Class) {
                return Optional.of((Class)genericType);
            }
            return Optional.of((Class)((ParameterizedType)genericType).getRawType());
        }
        throw new IllegalStateException(MessageFormatter.msg("No generic type information available on type '{}' for typeArgument with index {}", forType.getName(), typeArgumentIndex));
    }

    public Class<T> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }
}

